/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.sql.SQLException;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverPropertyCollection;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.ISessionProperties;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SQLConnectionState {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLConnectionState.class);
    private static final ILogger s_log = LoggerController.createLogger(SQLConnectionState.class);
    private Integer _transIsolation;
    private String _catalog;
    private boolean _autoCommit;
    private SQLDriverPropertyCollection _connProps;

    public void saveState(ISQLConnection con, ISessionProperties sessionProperties, IMessageHandler msgHandler, String selectedCatalogFromCatalogsComboBox) throws SQLException {
        String msg;
        try {
            this._transIsolation = null == con ? null : Integer.valueOf(con.getTransactionIsolation());
        }
        catch (SQLException ex) {
            msg = s_stringMgr.getString("SQLConnectionState.errorSavingIsolationState");
            s_log.error(msg, ex);
            msgHandler.showErrorMessage(msg);
        }
        try {
            this._catalog = selectedCatalogFromCatalogsComboBox;
            this._catalog = null == con ? this._catalog : con.getCatalog();
        }
        catch (SQLException ex) {
            msg = s_stringMgr.getString("SQLConnectionState.errorSavingCatalog");
            s_log.error(msg, ex);
            if (msgHandler == null) {
                throw ex;
            }
            msgHandler.showErrorMessage(msg);
        }
        try {
            this._autoCommit = sessionProperties.getAutoCommit();
            this._autoCommit = null == con ? this._autoCommit : con.getAutoCommit();
        }
        catch (SQLException ex) {
            msg = s_stringMgr.getString("SQLConnectionState.errorSavingAutoCommit");
            s_log.error(msg, ex);
            if (msgHandler == null) {
                throw ex;
            }
            msgHandler.showErrorMessage(msg);
        }
        this._connProps = null == con ? null : con.getConnectionProperties();
    }

    public void restoreState(ISQLConnection conn, IMessageHandler msgHandler) throws SQLException {
        if (conn == null) {
            throw new IllegalArgumentException("SQLConnection == null");
        }
        if (this._transIsolation != null) {
            try {
                conn.setTransactionIsolation(this._transIsolation);
            }
            catch (SQLException ex) {
                s_log.error("Error restoring transaction isolation", ex);
                if (msgHandler == null) {
                    throw ex;
                }
                msgHandler.showErrorMessage(ex, null);
            }
        }
        if (this._catalog != null) {
            try {
                conn.setCatalog(this._catalog);
            }
            catch (SQLException ex) {
                s_log.error("Error restoring current catalog", ex);
                if (msgHandler == null) {
                    throw ex;
                }
                msgHandler.showErrorMessage(ex, null);
            }
        }
        try {
            conn.setAutoCommit(this._autoCommit);
        }
        catch (SQLException ex) {
            s_log.error("Error restoring autocommit", ex);
            if (msgHandler == null) {
                throw ex;
            }
            msgHandler.showErrorMessage(ex, null);
        }
    }

    public SQLDriverPropertyCollection getConnectionProperties() {
        return this._connProps;
    }

    public boolean getAutoCommit() {
        return this._autoCommit;
    }
}

