/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.copyseparatedby;

import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.gui.TableCopyToClipboardUtil;
import net.sourceforge.squirrel_sql.fw.gui.action.copyseparatedby.CopySeparatedByCtrl;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class TableCopySeparatedByCommand {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TableCopySeparatedByCommand.class);
    private DataSetViewerTable _table;

    public TableCopySeparatedByCommand(DataSetViewerTable table) {
        this._table = table;
    }

    public void execute() {
        int nbrSelCols = this._table.getSelectedColumnCount();
        CopySeparatedByCtrl copySeparatedByCtrl = new CopySeparatedByCtrl(this._table, nbrSelCols > 1);
        if (!copySeparatedByCtrl.isOk()) {
            return;
        }
        String cellSeparator = copySeparatedByCtrl.getCellSeparator();
        String columnSeparator = copySeparatedByCtrl.getRowSeparator();
        if (1 == nbrSelCols) {
            columnSeparator = "";
        }
        int preferedLineLength = copySeparatedByCtrl.getPreferedLineLength();
        int nbrSelRows = this._table.getSelectedRowCount();
        int[] selRows = this._table.getSelectedRows();
        int[] selCols = this._table.getSelectedColumns();
        StringBuilder sb = new StringBuilder();
        for (int rowIdx = 0; rowIdx < nbrSelRows; ++rowIdx) {
            if (1 < nbrSelCols && rowIdx > 0) {
                sb.append(columnSeparator);
                if (preferedLineLength < this.getDistToLastNewLine(sb)) {
                    sb.append("\n");
                }
            }
            for (int colIdx = 0; colIdx < nbrSelCols; ++colIdx) {
                Object cellObj = this._table.getValueAt(selRows[rowIdx], selCols[colIdx]);
                if (nbrSelCols == 1) {
                    if (rowIdx > 0) {
                        sb.append(cellSeparator);
                        if (preferedLineLength < this.getDistToLastNewLine(sb)) {
                            sb.append("\n");
                        }
                    }
                } else if (colIdx > 0) {
                    sb.append(cellSeparator);
                }
                if (cellObj instanceof String && -1 < ((String)cellObj).indexOf(10)) {
                    int lineBreakPos = ((String)cellObj).indexOf(10);
                    sb.append((String)cellObj, 0, lineBreakPos);
                    continue;
                }
                if (null == cellObj) {
                    sb.append("<null>");
                    continue;
                }
                sb.append(cellObj.toString());
            }
        }
        TableCopyToClipboardUtil.copyToClip(sb);
    }

    private int getDistToLastNewLine(StringBuilder sb) {
        return sb.length() - sb.lastIndexOf("\n");
    }
}

