/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action;

import javax.swing.JTable;
import javax.swing.table.TableColumn;
import net.sourceforge.squirrel_sql.client.session.DataModelImplementationDetails;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ExtTableColumn;
import net.sourceforge.squirrel_sql.fw.gui.TableCopyToClipboardUtil;
import net.sourceforge.squirrel_sql.fw.gui.action.TableCopySqlPartCommandBase;
import net.sourceforge.squirrel_sql.fw.util.ICommand;

public class TableCopyInsertStatementCommand
extends TableCopySqlPartCommandBase
implements ICommand {
    private final JTable _table;
    private final DataModelImplementationDetails _dataModelImplementationDetails;

    public TableCopyInsertStatementCommand(JTable table, DataModelImplementationDetails dataModelImplementationDetails) {
        this._dataModelImplementationDetails = dataModelImplementationDetails;
        if (table == null) {
            throw new IllegalArgumentException("JTable == null");
        }
        this._table = table;
    }

    @Override
    public void execute() {
        int nbrSelRows = this._table.getSelectedRowCount();
        int nbrSelCols = this._table.getSelectedColumnCount();
        int[] selRows = this._table.getSelectedRows();
        int[] selCols = this._table.getSelectedColumns();
        if (selRows.length != 0 && selCols.length != 0) {
            StringBuffer buf = new StringBuffer();
            StringBuffer colNames = new StringBuffer();
            StringBuffer vals = new StringBuffer();
            for (int rowIdx = 0; rowIdx < nbrSelRows; ++rowIdx) {
                boolean firstCol = true;
                for (int colIdx = 0; colIdx < nbrSelCols; ++colIdx) {
                    TableColumn col = this._table.getColumnModel().getColumn(selCols[colIdx]);
                    ColumnDisplayDefinition colDef = null;
                    if (!(col instanceof ExtTableColumn)) continue;
                    colDef = ((ExtTableColumn)col).getColumnDisplayDefinition();
                    if (firstCol) {
                        colNames.append("INSERT INTO " + this._dataModelImplementationDetails.getTableName(colDef) + " (");
                        firstCol = false;
                        vals.append("(");
                    } else {
                        colNames.append(",");
                        vals.append(",");
                    }
                    Object cellObj = this._table.getValueAt(selRows[rowIdx], selCols[colIdx]);
                    colNames.append(colDef.getColumnName());
                    vals.append(this.getData(colDef, cellObj, TableCopySqlPartCommandBase.StatType.IN));
                }
                colNames.append(")");
                vals.append(")");
                buf.append(colNames).append(" VALUES ").append(vals);
                if (1 < this._dataModelImplementationDetails.getStatementSeparator().length()) {
                    buf.append(" ").append(this._dataModelImplementationDetails.getStatementSeparator()).append("\n");
                } else {
                    buf.append(this._dataModelImplementationDetails.getStatementSeparator()).append("\n");
                }
                colNames.setLength(0);
                vals.setLength(0);
            }
            TableCopyToClipboardUtil.copyToClip(buf);
        }
    }
}

