/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates;

import java.awt.Color;
import java.util.Comparator;
import java.util.HashSet;
import java.util.TreeMap;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.DuplicateHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.MarkDuplicatesMode;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.RowWrapper;
import net.sourceforge.squirrel_sql.fw.util.SquirrelConstants;

public class DuplicateRowsHandler
implements DuplicateHandler {
    private DataSetViewerTable _dataSetViewerTable;
    private TreeMap<RowWrapper, Color> _colorByDuplicateRow;

    public DuplicateRowsHandler(DataSetViewerTable dataSetViewerTable) {
        this._dataSetViewerTable = dataSetViewerTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markDuplicates(boolean selected) {
        try {
            if (!selected) {
                this._colorByDuplicateRow = null;
                return;
            }
            Comparator treeMapKeyComparator = Comparator.nullsFirst(Comparator.naturalOrder());
            this._colorByDuplicateRow = new TreeMap(treeMapKeyComparator);
            DataSetViewerTableModel dataSetViewerTableModel = this._dataSetViewerTable.getDataSetViewerTableModel();
            HashSet<RowWrapper> buf = new HashSet<RowWrapper>();
            for (int j = 0; j < dataSetViewerTableModel.getRowCount(); ++j) {
                RowWrapper row = new RowWrapper(dataSetViewerTableModel, j);
                if (buf.contains(row)) {
                    this._colorByDuplicateRow.put(row, null);
                    continue;
                }
                buf.add(row);
            }
            int count = 0;
            for (RowWrapper row : this._colorByDuplicateRow.keySet()) {
                if (0 == ++count % 2) {
                    this._colorByDuplicateRow.put(row, SquirrelConstants.DUPLICATE_COLOR_DARKER);
                    continue;
                }
                this._colorByDuplicateRow.put(row, SquirrelConstants.DUPLICATE_COLOR);
            }
        }
        finally {
            this._dataSetViewerTable.repaint();
        }
    }

    @Override
    public MarkDuplicatesMode getMode() {
        return MarkDuplicatesMode.DUPLICATE_ROWS;
    }

    @Override
    public Color getBackgroundForCell(int row, int column, Object value) {
        if (null == this._colorByDuplicateRow) {
            return null;
        }
        RowWrapper rowWrapperBuf = new RowWrapper();
        rowWrapperBuf.init(this._dataSetViewerTable.getDataSetViewerTableModel(), row);
        return this._colorByDuplicateRow.get(rowWrapperBuf);
    }
}

