/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.datasetviewer.BeanPorpertyColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.util.EmptyIterator;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class JavabeanArrayDataSet
implements IDataSet {
    private Object[] _currentRow;
    private List<Object[]> _data;
    private Iterator<Object[]> _dataIter = new EmptyIterator<Object[]>();
    private DataSetDefinition _dataSetDefinition;
    private BeanInfo _info;
    private Class _beanClass;
    private BeanPorpertyColumnDisplayDefinition[] _beanPorpertyColumnDisplayDefinitions;
    private HashMap<String, String> _headers = new HashMap();
    private HashMap<String, Integer> _positions = new HashMap();
    private HashMap<String, Integer> _absoluteWidths = new HashMap();
    private HashSet<String> _ignoreProperties = new HashSet();

    public JavabeanArrayDataSet(Object[] beans) throws DataSetException {
        this._beanClass = null == beans || 0 == beans.length ? Object.class : beans[0].getClass();
        this.setJavaBeanArray(beans);
    }

    public JavabeanArrayDataSet(Class beanClass) {
        this._beanClass = beanClass;
    }

    @Override
    public final int getColumnCount() {
        return this._beanPorpertyColumnDisplayDefinitions.length;
    }

    @Override
    public DataSetDefinition getDataSetDefinition() {
        return this._dataSetDefinition;
    }

    @Override
    public synchronized boolean next(IMessageHandler msgHandler) throws DataSetException {
        if (this._dataIter.hasNext()) {
            this._currentRow = this._dataIter.next();
            return true;
        }
        return false;
    }

    @Override
    public synchronized Object get(int columnIndex) {
        return this._currentRow[columnIndex];
    }

    protected Object executeGetter(Object bean, Method getter) throws InvocationTargetException, IllegalAccessException {
        return getter.invoke(bean, (Object[])null);
    }

    public void setJavaBeanList(List list) {
        this.setJavaBeanArray(list.toArray(new Object[list.size()]));
    }

    public void setJavaBeanArray(Object[] beans) {
        this.initColsAndBeanInfo(this._beanClass);
        if (beans.length > 0) {
            try {
                for (int i = 0; i < beans.length; ++i) {
                    this.processBeanInfo(beans[i], this._info);
                }
            }
            catch (Exception ex) {
                throw Utilities.wrapRuntime(ex);
            }
            this._dataIter = this._data.iterator();
        }
    }

    private void initColsAndBeanInfo(Class beanClass) {
        try {
            this._info = Introspector.getBeanInfo(beanClass, 1);
            this.initializeCols(this._info);
        }
        catch (IntrospectionException ex) {
            throw Utilities.wrapRuntime(ex);
        }
    }

    private void processBeanInfo(Object bean, BeanInfo info) throws InvocationTargetException, IllegalAccessException {
        ArrayList<Object> line = new ArrayList<Object>();
        for (int i = 0; i < this._beanPorpertyColumnDisplayDefinitions.length; ++i) {
            Method getter = this._beanPorpertyColumnDisplayDefinitions[i].getPropDesc().getReadMethod();
            if (getter == null) continue;
            line.add(this.executeGetter(bean, getter));
        }
        this._data.add(line.toArray(new Object[line.size()]));
    }

    private void initializeCols(BeanInfo info) {
        this._data = new ArrayList<Object[]>();
        this._beanPorpertyColumnDisplayDefinitions = this.createColumnDefinitions(info);
        this._dataSetDefinition = new DataSetDefinition(BeanPorpertyColumnDisplayDefinition.getColDefs(this._beanPorpertyColumnDisplayDefinitions));
    }

    private BeanPorpertyColumnDisplayDefinition[] createColumnDefinitions(BeanInfo info) {
        PropertyDescriptor[] propDesc = info.getPropertyDescriptors();
        ArrayList<BeanPorpertyColumnDisplayDefinition> columnDefs = new ArrayList<BeanPorpertyColumnDisplayDefinition>();
        for (int i = 0; i < propDesc.length; ++i) {
            if (!this.isValidProperty(propDesc[i])) continue;
            ColumnDisplayDefinition colDef = null == this._headers.get(propDesc[i].getName()) ? new ColumnDisplayDefinition(200, propDesc[i].getDisplayName()) : new ColumnDisplayDefinition(200, this._headers.get(propDesc[i].getName()));
            colDef.setUserProperty(propDesc[i].getName());
            if (null != this._absoluteWidths.get(propDesc[i].getName())) {
                colDef.setAsoluteWidth(this._absoluteWidths.get(propDesc[i].getName()));
            }
            columnDefs.add(new BeanPorpertyColumnDisplayDefinition(colDef, propDesc[i]));
        }
        if (0 < this._positions.size()) {
            Collections.sort(columnDefs, new Comparator<BeanPorpertyColumnDisplayDefinition>(){

                @Override
                public int compare(BeanPorpertyColumnDisplayDefinition o1, BeanPorpertyColumnDisplayDefinition o2) {
                    return JavabeanArrayDataSet.this.comparePosition(o1, o2);
                }
            });
        }
        return columnDefs.toArray(new BeanPorpertyColumnDisplayDefinition[columnDefs.size()]);
    }

    private int comparePosition(BeanPorpertyColumnDisplayDefinition o1, BeanPorpertyColumnDisplayDefinition o2) {
        if (null == this._positions.get(o1.getColDef().getUserProperty()) && null == this._positions.get(o2.getColDef().getUserProperty())) {
            return 0;
        }
        if (null == this._positions.get(o1.getColDef().getUserProperty()) && null != this._positions.get(o2.getColDef().getUserProperty())) {
            return 1;
        }
        if (null != this._positions.get(o1.getColDef().getUserProperty()) && null == this._positions.get(o2.getColDef().getUserProperty())) {
            return -1;
        }
        return this._positions.get(o1.getColDef().getUserProperty()).compareTo(this._positions.get(o2.getColDef().getUserProperty()));
    }

    private boolean isValidProperty(PropertyDescriptor propertyDescriptor) {
        return false == this._ignoreProperties.contains(propertyDescriptor.getName()) && false == propertyDescriptor.getReadMethod().getDeclaringClass().equals(Object.class);
    }

    public void setColHeader(String prop, String header) {
        this._headers.put(prop, header);
    }

    public void setColPos(String prop, int pos) {
        this._positions.put(prop, pos);
    }

    public void setAbsoluteWidht(String prop, int width) {
        this._absoluteWidths.put(prop, width);
    }

    public void setIgnoreProperty(String ignoreProperty) {
        this._ignoreProperties.add(ignoreProperty);
    }
}

