/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.util.codereformat;

public class SectionsHandler {
    private boolean _indentSections;
    private boolean _currentPieceIsSectionBegin;
    private int _offset;
    private boolean _sqlHasSections;

    public SectionsHandler(boolean indentSections) {
        this._indentSections = indentSections;
    }

    public void before(String piece) {
        this._currentPieceIsSectionBegin = SectionsHandler.isSectionBegin(piece);
        if (this._currentPieceIsSectionBegin) {
            this._sqlHasSections = true;
        }
        if (")".equals(piece) && this._offset > 0) {
            --this._offset;
        }
    }

    public void after(String piece) {
        if ("(".equals(piece)) {
            ++this._offset;
        }
    }

    public int getExtraIndentCount() {
        if (!this._indentSections || !this._sqlHasSections) {
            return 0;
        }
        if (this._currentPieceIsSectionBegin) {
            return this._offset;
        }
        return this._offset + 1;
    }

    public static boolean isSectionBegin(String piece) {
        return SectionsHandler.isSelectSectionBegin(piece) || SectionsHandler.beginsWithKeyword(piece, "FROM") || SectionsHandler.beginsWithKeyword(piece, "WHERE") || SectionsHandler.beginsWithKeyword(piece, "UNION") || SectionsHandler.beginsWithKeyword(piece, "GROUP") || SectionsHandler.beginsWithKeyword(piece, "ORDER");
    }

    public static boolean isSelectSectionBegin(String piece) {
        return SectionsHandler.beginsWithKeyword(piece, "SELECT");
    }

    private static boolean beginsWithKeyword(String piece, String keyword) {
        String trimedUcPiece = piece.trim().toUpperCase();
        if (!trimedUcPiece.startsWith(keyword.toUpperCase())) {
            return false;
        }
        return trimedUcPiece.length() == keyword.length() || Character.isWhitespace(trimedUcPiece.charAt(keyword.length()));
    }
}

