/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.Timer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScaleTableModel;
import net.sourceforge.squirrel_sql.fw.props.Props;

public class DataScaleTableColumnWidthsPersister {
    private static final int DEFAULT_COL_WIDTH_COLUMN = 100;
    private static final int DEFAULT_COL_WIDTH_DATA = 1000;
    private static final String PREF_KEY_COL_WIDTH_COLUMN = "Squirrel.overview.colWidthColumn";
    private static final String PREF_KEY_COL_WIDTH_DATA = "Squirrel.overview.colWidthData";
    private final Timer _timer;
    private JTableHeader _tableHeader;

    public DataScaleTableColumnWidthsPersister(JTableHeader tableHeader) {
        this._tableHeader = tableHeader;
        tableHeader.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                DataScaleTableColumnWidthsPersister.this.onMouseDraggedOnTableHeader(e);
            }
        });
        tableHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (2 == e.getClickCount() && DataScaleTableColumnWidthsPersister.this._tableHeader.getCursor().getType() == 11) {
                    DataScaleTableColumnWidthsPersister.this.onMouseDraggedOnTableHeader(e);
                }
            }
        });
        this._timer = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataScaleTableColumnWidthsPersister.this.saveColumnWidths();
            }
        });
        this._timer.setRepeats(false);
    }

    private void onMouseDraggedOnTableHeader(MouseEvent e) {
        this._timer.restart();
    }

    public static int getColumnWidthForColName(String colName) {
        if (DataScaleTableModel.COL_NAME_COLUMN.equals(colName)) {
            return Props.getInt(PREF_KEY_COL_WIDTH_COLUMN, 100);
        }
        if (DataScaleTableModel.COL_NAME_DATA.equals(colName)) {
            return Props.getInt(PREF_KEY_COL_WIDTH_DATA, 1000);
        }
        throw new IllegalArgumentException("Unknown column name " + colName);
    }

    private void saveColumnWidths() {
        TableColumnModel columnModel = this._tableHeader.getColumnModel();
        int wColumn = 100;
        int wData = 1000;
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            if (DataScaleTableModel.COL_NAME_COLUMN.equals(columnModel.getColumn(i).getHeaderValue())) {
                wColumn = columnModel.getColumn(i).getWidth();
                continue;
            }
            if (!DataScaleTableModel.COL_NAME_DATA.equals(columnModel.getColumn(i).getHeaderValue())) continue;
            wData = columnModel.getColumn(i).getWidth();
        }
        Props.putInt(PREF_KEY_COL_WIDTH_COLUMN, wColumn);
        Props.putInt(PREF_KEY_COL_WIDTH_DATA, wData);
    }
}

