/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.filemanager;

import java.util.HashMap;
import javax.swing.JFileChooser;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.FileExtensionFilter;

public class FileChooserManager {
    private static final String PREF_PRE_SELECTED_FILE_FILTER = "Squirrel.filechoosermanager.preselfilefilter";
    public static final String FILE_ENDING_TXT = ".txt";
    public static final String FILE_ENDING_SQL = ".sql";
    public static final String FILE_ENDING_NONE = "FILE_ENDING_NONE";
    private JFileChooser _fileChooser;
    private HashMap<FileExtensionFilter, String> _fileAppenixes = new HashMap();
    private final FileExtensionFilter _txtFilter;
    private final FileExtensionFilter _sqlFilter;
    private boolean _saveFileFilterProps = true;

    public FileChooserManager() {
        this._fileChooser = new JFileChooser();
        this._txtFilter = new FileExtensionFilter("Text files", new String[]{FILE_ENDING_TXT});
        this._fileChooser.addChoosableFileFilter(this._txtFilter);
        this._fileAppenixes.put(this._txtFilter, FILE_ENDING_TXT);
        this._sqlFilter = new FileExtensionFilter("SQL files", new String[]{FILE_ENDING_SQL});
        this._fileChooser.addChoosableFileFilter(this._sqlFilter);
        this._fileAppenixes.put(this._sqlFilter, FILE_ENDING_SQL);
        String fileEndingPref = Props.getString(PREF_PRE_SELECTED_FILE_FILTER, FILE_ENDING_NONE);
        if (FILE_ENDING_SQL.equals(fileEndingPref)) {
            this._fileChooser.setFileFilter(this._sqlFilter);
        } else if (FILE_ENDING_TXT.equals(fileEndingPref)) {
            this._fileChooser.setFileFilter(this._txtFilter);
        }
    }

    public String getSelectedFileEnding() {
        return this._fileAppenixes.get(this._fileChooser.getFileFilter());
    }

    public JFileChooser getFileChooser() {
        return this._fileChooser;
    }

    public void saveWasApproved() {
        if (!this._saveFileFilterProps) {
            return;
        }
        if (null != this.getSelectedFileEnding()) {
            Props.putString(PREF_PRE_SELECTED_FILE_FILTER, this.getSelectedFileEnding());
        } else {
            Props.putString(PREF_PRE_SELECTED_FILE_FILTER, FILE_ENDING_NONE);
        }
    }

    public void replaceSqlFileExtensionFilterBy(FileExtensionFilter fileExtensionFilter, String fileEndingWithDot) {
        this._fileChooser.removeChoosableFileFilter(this._sqlFilter);
        this._fileChooser.addChoosableFileFilter(fileExtensionFilter);
        this._fileChooser.setFileFilter(fileExtensionFilter);
        this._fileAppenixes.remove(this._sqlFilter);
        this._fileAppenixes.put(fileExtensionFilter, fileEndingWithDot);
        this._saveFileFilterProps = false;
    }
}

