/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.action.EditExtrasUtilities;
import net.sourceforge.squirrel_sql.fw.util.BaseException;
import net.sourceforge.squirrel_sql.fw.util.ICommand;

class InQuotesCommand
implements ICommand {
    private final ISQLPanelAPI _api;
    private boolean _sbAppend;

    InQuotesCommand(ISQLPanelAPI api, boolean sbAppend) {
        this._api = api;
        this._sbAppend = sbAppend;
    }

    @Override
    public void execute() throws BaseException {
        ISQLEntryPanel entryPanel = this._api.getSQLEntryPanel();
        InQuotesCommand.quoteSQL(entryPanel, this._sbAppend, this._api.getSession().getApplication().getSquirrelPreferences().isCopyQuotedSqlsToClip());
    }

    public static void quoteSQL(ISQLEntryPanel entryPanel, boolean sbAppend) {
        InQuotesCommand.quoteSQL(entryPanel, sbAppend, false);
    }

    public static void quoteSQL(ISQLEntryPanel entryPanel, boolean sbAppend, boolean copyToCLip) {
        int[] bounds = entryPanel.getBoundsOfSQLToBeExecuted();
        if (bounds[0] == bounds[1]) {
            return;
        }
        String textToQuote = entryPanel.getSQLToBeExecuted();
        if (null == textToQuote) {
            return;
        }
        String quotedText = EditExtrasUtilities.quoteText(textToQuote, sbAppend);
        entryPanel.setSelectionStart(bounds[0]);
        entryPanel.setSelectionEnd(bounds[1]);
        entryPanel.replaceSelection(quotedText);
        if (copyToCLip) {
            StringSelection ss = new StringSelection(quotedText);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, ss);
        }
    }
}

