/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.mainframe.action;

import java.sql.DriverManager;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.mainframe.action.OpenConnectionCommandListener;
import net.sourceforge.squirrel_sql.client.session.action.reconnect.ReconnectInfo;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverManager;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverPropertyCollection;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class OpenConnectionCommand {
    private ISQLAlias _sqlAlias;
    private final String _userName;
    private final String _password;
    private final SQLDriverPropertyCollection _props;
    private SQLConnection _conn;
    private ReconnectInfo _reconnectInfo;

    public OpenConnectionCommand(ISQLAlias sqlAlias, String userName, String password, SQLDriverPropertyCollection props) {
        this(sqlAlias, userName, password, props, null);
    }

    public OpenConnectionCommand(ISQLAlias sqlAlias, String userName, String password, SQLDriverPropertyCollection props, ReconnectInfo reconnectInfo) {
        if (sqlAlias == null) {
            throw new IllegalArgumentException("Null ISQLAlias passed");
        }
        this._sqlAlias = sqlAlias;
        this._userName = userName;
        this._password = password;
        this._props = props;
        this._reconnectInfo = reconnectInfo;
    }

    public void execute(OpenConnectionCommandListener openConnectionCommandListener) {
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        Runnable taskConnect = () -> this.executeConnect();
        Future<?> future = executorService.submit(taskConnect);
        Runnable taskAwaitConnect = () -> this.awaitConnection(future, openConnectionCommandListener);
        executorService.submit(taskAwaitConnect);
    }

    public void executeAndWait() {
        this.executeConnect();
    }

    private void awaitConnection(Future future, final OpenConnectionCommandListener openConnectionCommandListener) {
        try {
            if (0 < DriverManager.getLoginTimeout()) {
                future.get(DriverManager.getLoginTimeout(), TimeUnit.SECONDS);
            } else {
                future.get();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    openConnectionCommandListener.openConnectionFinished(null);
                }
            });
        }
        catch (Throwable t) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    openConnectionCommandListener.openConnectionFinished(t);
                }
            });
        }
    }

    private void executeConnect() {
        this._conn = null;
        IIdentifier driverID = this._sqlAlias.getDriverIdentifier();
        ISQLDriver sqlDriver = Main.getApplication().getDataCache().getDriver(driverID);
        SQLDriverManager mgr = Main.getApplication().getSQLDriverManager();
        try {
            this._conn = mgr.getConnection(sqlDriver, this._sqlAlias, this._userName, this._password, this._props, this._reconnectInfo);
        }
        catch (Throwable th) {
            throw Utilities.wrapRuntime(th);
        }
    }

    public SQLConnection getSQLConnection() {
        return this._conn;
    }
}

