/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.mainframe;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.session.MessagePanel;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class SplitPnResizeHandler {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SplitPnResizeHandler.class);
    private static final String PREFS_KEY_MESSAGEPANEL_HEIGHT = "squirrelSql_msgPanel_height";
    private boolean m_hasBeenVisible;
    private JSplitPane _splitPn;
    private MessagePanel _msgPnl;

    public SplitPnResizeHandler(JSplitPane splitPn, MessagePanel msgPnl) {
        this._splitPn = splitPn;
        this._msgPnl = msgPnl;
        String key = s_stringMgr.getString("MainFrame.saveSize");
        AbstractAction saveSplitDividerLocAction = new AbstractAction(key){

            @Override
            public void actionPerformed(ActionEvent e) {
                int msgPanelHeight = ((SplitPnResizeHandler)SplitPnResizeHandler.this)._splitPn.getBottomComponent().getSize().height;
                Props.putInt(SplitPnResizeHandler.PREFS_KEY_MESSAGEPANEL_HEIGHT, msgPanelHeight);
            }
        };
        this._msgPnl.addToMessagePanelPopup(saveSplitDividerLocAction);
        key = s_stringMgr.getString("MainFrame.saveSize0");
        AbstractAction save0SplitDividerLocAction = new AbstractAction(key){

            @Override
            public void actionPerformed(ActionEvent e) {
                Props.putInt(SplitPnResizeHandler.PREFS_KEY_MESSAGEPANEL_HEIGHT, 0);
                SplitPnResizeHandler.this.setUnexpanded();
            }
        };
        this._msgPnl.addToMessagePanelPopup(save0SplitDividerLocAction);
        key = s_stringMgr.getString("MainFrame.restoreSize");
        AbstractAction setSplitDividerLocAction = new AbstractAction(key){

            @Override
            public void actionPerformed(ActionEvent e) {
                int prefMsgPanelHeight = Props.getInt(SplitPnResizeHandler.PREFS_KEY_MESSAGEPANEL_HEIGHT, -1);
                if (-1 != prefMsgPanelHeight) {
                    if (0 == prefMsgPanelHeight) {
                        SplitPnResizeHandler.this.setUnexpanded();
                    } else {
                        int divLoc = SplitPnResizeHandler.this.getDividerLocation(prefMsgPanelHeight, SplitPnResizeHandler.this._splitPn);
                        SplitPnResizeHandler.this._splitPn.setDividerLocation(divLoc);
                    }
                }
            }
        };
        this._msgPnl.addToMessagePanelPopup(setSplitDividerLocAction);
    }

    private void setUnexpanded() {
        this._splitPn.setDividerLocation(this._splitPn.getMaximumDividerLocation() + 100);
    }

    void resizeSplitOnStartup() {
        if (!this.m_hasBeenVisible) {
            this.m_hasBeenVisible = true;
            final int prefMsgPanelHeight = Props.getInt(PREFS_KEY_MESSAGEPANEL_HEIGHT, -1);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (-1 == prefMsgPanelHeight) {
                        int divLoc = SplitPnResizeHandler.this.getDividerLocation(50, SplitPnResizeHandler.this._splitPn);
                        SplitPnResizeHandler.this._splitPn.setDividerLocation(divLoc);
                    } else if (0 == prefMsgPanelHeight) {
                        SplitPnResizeHandler.this.tryForceUnexpanded();
                    } else {
                        int divLoc = SplitPnResizeHandler.this.getDividerLocation(prefMsgPanelHeight, SplitPnResizeHandler.this._splitPn);
                        SplitPnResizeHandler.this._splitPn.setDividerLocation(divLoc);
                    }
                }
            });
        }
    }

    private void tryForceUnexpanded() {
        this.setUnexpanded();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SplitPnResizeHandler.this.setUnexpanded();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private int getDividerLocation(int wantedBottomComponentHeight, JSplitPane splitPn) {
        int splitBarSize = splitPn.getSize().height - splitPn.getBottomComponent().getSize().height - splitPn.getTopComponent().getSize().height - 1;
        int divLoc = splitPn.getSize().height - wantedBottomComponentHeight - splitBarSize;
        return divLoc;
    }
}

