/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.desktopcontainer;

import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.TabbedStyleHintController;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;

public class DesktopStyle {
    private StyleEnum _desktopStyle = StyleEnum.INTERNAL_FRAME_STYLE;

    public DesktopStyle(SquirrelPreferences prefs) {
        if (prefs.getTabbedStyle()) {
            this._desktopStyle = StyleEnum.DOCK_TAB_STYLE;
        } else if (prefs.getShowTabbedStyleHint()) {
            TabbedStyleHintController ctrlHint = new TabbedStyleHintController();
            if (ctrlHint.isUseTabbedLayout()) {
                prefs.setTabbedStyle(true);
                prefs.save();
                this._desktopStyle = StyleEnum.DOCK_TAB_STYLE;
            } else if (ctrlHint.isDontShowAgain()) {
                prefs.setShowTabbedStyleHint(false);
                prefs.save();
            }
        }
    }

    public boolean isDockTabStyle() {
        return StyleEnum.DOCK_TAB_STYLE == this._desktopStyle;
    }

    public boolean isInternalFrameStyle() {
        return StyleEnum.INTERNAL_FRAME_STYLE == this._desktopStyle;
    }

    public boolean supportsLayers() {
        return this._desktopStyle._supportsLayers;
    }

    public static enum StyleEnum {
        DOCK_TAB_STYLE(false),
        INTERNAL_FRAME_STYLE(true);

        private boolean _supportsLayers;

        private StyleEnum(boolean supportsLayers) {
            this._supportsLayers = supportsLayers;
        }
    }
}

