/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import net.sourceforge.squirrel_sql.client.ApplicationListener;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.db.IBaseList;
import net.sourceforge.squirrel_sql.fw.gui.SortedListModel;
import net.sourceforge.squirrel_sql.fw.props.Props;

public abstract class BaseList
implements IBaseList {
    private ArrayList<ListDataListener> _listeners = new ArrayList();
    private JList _list = new JList(){

        @Override
        public String getToolTipText(MouseEvent event) {
            return BaseList.this.getToolTipText(event);
        }
    };
    private JScrollPane _comp = new JScrollPane(this._list);

    public BaseList(SortedListModel sortedListModel, IApplication app) {
        this._list.setModel(sortedListModel);
        this.getList().getSelectionModel().setSelectionMode(0);
        this._list.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent evt) {
                BaseList.this.onIntervalAdded(evt);
            }

            @Override
            public void intervalRemoved(ListDataEvent evt) {
                BaseList.this.onIntervalRemoved(evt);
            }

            @Override
            public void contentsChanged(ListDataEvent evt) {
                BaseList.this.onContentsChanged(evt);
            }
        });
        this._comp.setPreferredSize(new Dimension(100, 100));
        app.addApplicationListener(new ApplicationListener(){

            @Override
            public void saveApplicationState() {
                BaseList.this.onSaveApplicationState();
            }
        });
        this.setSelIxFromPrefs();
    }

    private void setSelIxFromPrefs() {
        int selIx = Props.getInt(this.getSelIndexPrefKey(), 0);
        if (selIx >= 0 && selIx < this._list.getModel().getSize()) {
            this._list.setSelectedIndex(selIx);
        }
    }

    private void onSaveApplicationState() {
        Props.putInt(this.getSelIndexPrefKey(), this.getList().getSelectedIndex());
    }

    protected JList getList() {
        return this._list;
    }

    protected abstract String getToolTipText(MouseEvent var1);

    private void onContentsChanged(ListDataEvent evt) {
        for (ListDataListener listener : this._listeners.toArray(new ListDataListener[0])) {
            listener.contentsChanged(evt);
        }
    }

    private void onIntervalRemoved(ListDataEvent evt) {
        int lastIdx;
        int nextIdx = evt.getIndex0();
        if (nextIdx > (lastIdx = this._list.getModel().getSize() - 1)) {
            nextIdx = lastIdx;
        }
        this._list.setSelectedIndex(nextIdx);
        for (ListDataListener listener : this._listeners.toArray(new ListDataListener[0])) {
            listener.intervalRemoved(evt);
        }
    }

    private void onIntervalAdded(ListDataEvent evt) {
        this._list.setSelectedIndex(evt.getIndex0());
        for (ListDataListener listener : this._listeners.toArray(new ListDataListener[0])) {
            listener.intervalAdded(evt);
        }
    }

    @Override
    public JComponent getComponent() {
        return this._comp;
    }

    @Override
    public void selectListEntryAtPoint(Point point) {
        int selectEventListIndex = this._list.locationToIndex(point);
        if (this._list.getSelectionMode() == 0) {
            int selectedIndex = this._list.getSelectedIndex();
            if (selectedIndex != selectEventListIndex) {
                this._list.setSelectedIndex(selectEventListIndex);
            }
        } else {
            int[] selectedIndices = this._list.getSelectedIndices();
            boolean alreadySelected = false;
            for (int selectedIndex : selectedIndices) {
                if (selectedIndex != selectEventListIndex) continue;
                alreadySelected = true;
            }
            if (!alreadySelected) {
                this._list.setSelectedIndex(selectEventListIndex);
            }
        }
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this._list.addMouseListener(mouseListener);
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        this._list.removeMouseListener(mouseListener);
    }

    public abstract String getSelIndexPrefKey();
}

