/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.aboutdialog;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.Timer;
import net.sourceforge.squirrel_sql.fw.gui.PropertyPanel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

class MemoryPanel
extends PropertyPanel
implements ActionListener {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MemoryPanel.class);
    private final JLabel _totalMemoryLbl = new JLabel();
    private final JLabel _usedMemoryLbl = new JLabel();
    private final JLabel _freeMemoryLbl = new JLabel();
    private Timer _timer;

    MemoryPanel() {
        this.add(new JLabel(s_stringMgr.getString("AboutBoxDialog.heapsize")), this._totalMemoryLbl);
        this.add(new JLabel(s_stringMgr.getString("AboutBoxDialog.usedheap")), this._usedMemoryLbl);
        this.add(new JLabel(s_stringMgr.getString("AboutBoxDialog.freeheap")), this._freeMemoryLbl);
        JButton gcBtn = new JButton(s_stringMgr.getString("AboutBoxDialog.gc"));
        gcBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Utilities.garbageCollect();
            }
        });
        this.add((Component)gcBtn, (Component)new JLabel(""));
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.stopTimer();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.updateMemoryStatus();
    }

    synchronized void startTimer() {
        if (this._timer == null) {
            this.updateMemoryStatus();
            this._timer = new Timer(2000, this);
            this._timer.start();
        }
    }

    synchronized void stopTimer() {
        if (this._timer != null) {
            this._timer.stop();
            this._timer = null;
        }
    }

    private void updateMemoryStatus() {
        Runtime rt = Runtime.getRuntime();
        long totalMemory = rt.totalMemory();
        long freeMemory = rt.freeMemory();
        long usedMemory = totalMemory - freeMemory;
        this._totalMemoryLbl.setText(Utilities.formatSize(totalMemory, 1));
        this._usedMemoryLbl.setText(Utilities.formatSize(usedMemory, 1));
        this._freeMemoryLbl.setText(Utilities.formatSize(freeMemory, 1));
    }
}

