/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.codecompletion;

import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.event.SimpleSessionListener;
import net.sourceforge.squirrel_sql.fw.completion.CompletionCandidates;
import net.sourceforge.squirrel_sql.fw.completion.CompletionInfo;
import net.sourceforge.squirrel_sql.fw.completion.Completor;
import net.sourceforge.squirrel_sql.fw.completion.CompletorListener;
import net.sourceforge.squirrel_sql.fw.completion.ICompletorModel;
import net.sourceforge.squirrel_sql.fw.completion.util.CompletionParser;
import net.sourceforge.squirrel_sql.fw.resources.IResources;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CodeCompletionInfo;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CodeCompletionInfoCollection;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CodeCompletionPlugin;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CodeCompletorModel;

public class CompleteCodeAction
extends SquirrelAction {
    private ISQLEntryPanel _sqlEntryPanel;
    private Completor _cc;
    private CodeCompletorModel _model;

    public CompleteCodeAction(IApplication app, CodeCompletionPlugin plugin, ISQLEntryPanel sqlEntryPanel, ISession session, CodeCompletionInfoCollection codeCompletionInfos, JComponent popupParent) {
        super(app, (IResources)plugin.getResources());
        this._sqlEntryPanel = sqlEntryPanel;
        this._model = new CodeCompletorModel(session, plugin, codeCompletionInfos, sqlEntryPanel.getIdentifier());
        CompletorListener completorListener = new CompletorListener(){

            public void completionSelected(CompletionInfo completion, int replaceBegin, int keyCode, int modifiers) {
                CompleteCodeAction.this.performCompletionSelected((CodeCompletionInfo)completion, replaceBegin, keyCode, modifiers);
            }
        };
        this._cc = null != popupParent ? new Completor((JTextComponent)this._sqlEntryPanel.getTextComponent(), (ICompletorModel)this._model, completorListener, Completor.DEFAULT_POP_UP_BACK_GROUND, false, popupParent) : new Completor((JTextComponent)this._sqlEntryPanel.getTextComponent(), (ICompletorModel)this._model, completorListener, Completor.DEFAULT_POP_UP_BACK_GROUND, false);
        session.addSimpleSessionListener(new SimpleSessionListener(){

            public void sessionClosed() {
                CompleteCodeAction.this._cc.disposePopup();
            }
        });
        this._sqlEntryPanel.addSQLTokenListener(this._model.getSQLTokenListener());
    }

    public void actionPerformed(ActionEvent evt) {
        this._cc.show();
    }

    private void performCompletionSelected(CodeCompletionInfo completion, int replaceBegin, int keyCode, int modifiers) {
        String textTillCaret = this._cc.getTextTillCaret();
        if (32 == keyCode && modifiers == 2) {
            CompletionCandidates completionCandidates = this._model.getCompletionCandidates(textTillCaret);
            this._sqlEntryPanel.setSelectionStart(replaceBegin);
            this._sqlEntryPanel.setSelectionEnd(this._sqlEntryPanel.getCaretPosition());
            this._sqlEntryPanel.replaceSelection(completionCandidates.getAllCandidatesPrefix(false));
            SwingUtilities.invokeLater(() -> this._cc.show());
        } else if (9 == keyCode) {
            this._sqlEntryPanel.setSelectionStart(replaceBegin);
            this._sqlEntryPanel.setSelectionEnd(this.getNextStopCharPos(this._sqlEntryPanel.getCaretPosition()));
            this._sqlEntryPanel.replaceSelection(completion.getCompletionString(new CompletionParser(textTillCaret)));
            this.adjustCaret(completion);
            this._sqlEntryPanel.triggerParser();
        } else {
            this._sqlEntryPanel.setSelectionStart(replaceBegin);
            this._sqlEntryPanel.setSelectionEnd(this._sqlEntryPanel.getCaretPosition());
            this._sqlEntryPanel.replaceSelection(completion.getCompletionString(new CompletionParser(textTillCaret)));
            this.adjustCaret(completion);
            this._sqlEntryPanel.triggerParser();
        }
    }

    private void adjustCaret(CodeCompletionInfo completion) {
        if (0 < completion.getMoveCarretBackCount()) {
            this._sqlEntryPanel.setCaretPosition(this._sqlEntryPanel.getCaretPosition() - completion.getMoveCarretBackCount());
        }
    }

    private int getNextStopCharPos(int startPos) {
        int retPos;
        String text = this._sqlEntryPanel.getText();
        for (retPos = startPos; retPos < text.length(); ++retPos) {
            char c = text.charAt(retPos);
            if (!Character.isWhitespace(c) && '.' != c && ',' != c && ';' != c && '\"' != c && '\'' != c && '(' != c && ')' != c && '=' != c) continue;
            return retPos;
        }
        return retPos;
    }
}

