/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComponent;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.event.ISessionListener;
import net.sourceforge.squirrel_sql.client.session.event.SessionAdapter;
import net.sourceforge.squirrel_sql.client.session.event.SessionEvent;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernateConnection;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernatePluginResources;
import net.sourceforge.squirrel_sql.plugins.hibernate.HqlResultPanel;
import net.sourceforge.squirrel_sql.plugins.hibernate.LimitObjectCountDialog;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.ObjectResultController;

public class HqlResultPanelManager {
    private static final String PREF_KEY_VIEW_LIMIT_OBJECT_COUNT = "SquirrelSQL.hibernate.limitObjectsCount";
    private static final String PREF_KEY_VIEW_LIMIT_OBJECT_COUNT_VAL = "SquirrelSQL.hibernate.limitObjectsCountVal";
    private static final String PREF_KEY_USE_CONNECTION_OF = "SquirrelSQL.hibernate.useConnectionOf";
    private HqlResultPanel _hqlResultPanel;
    private ObjectResultController _objectResultController;

    public HqlResultPanelManager(final ISession session, HibernatePluginResources resource) {
        this._objectResultController = new ObjectResultController(session, resource);
        this._hqlResultPanel = new HqlResultPanel(this._objectResultController.getPanel(), resource);
        session.getApplication().getSessionManager().addSessionListener((ISessionListener)new SessionAdapter(){

            public void sessionClosing(SessionEvent evt) {
                HqlResultPanelManager.this.onSessionClosing();
                session.getApplication().getSessionManager().removeSessionListener((ISessionListener)this);
            }
        });
        this._hqlResultPanel.chkLimitObjectCount.setSelected(Props.getBoolean((String)PREF_KEY_VIEW_LIMIT_OBJECT_COUNT, (boolean)false));
        this._hqlResultPanel.nbrLimitRows.setInt(Props.getInt((String)PREF_KEY_VIEW_LIMIT_OBJECT_COUNT_VAL, (int)100));
        this._hqlResultPanel.nbrLimitRows.setEnabled(this._hqlResultPanel.chkLimitObjectCount.isSelected());
        int ordinalToSelect = Props.getInt((String)PREF_KEY_USE_CONNECTION_OF, (int)HqlResultPanel.UseConnectionOf.OF_HIBBERNAT_CONFIG.ordinal());
        this._hqlResultPanel.cboUseConnectionOf.setSelectedItem((Object)HqlResultPanel.UseConnectionOf.getByOrdinal(ordinalToSelect));
        this._hqlResultPanel.chkLimitObjectCount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HqlResultPanelManager.this.onLimitRowsChanged();
            }
        });
        this._hqlResultPanel.cboUseConnectionOf.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                HqlResultPanelManager.this.onUseConnectionOfChanged(e);
            }
        });
    }

    private void onUseConnectionOfChanged(ItemEvent e) {
        if (2 == e.getStateChange()) {
            return;
        }
        HqlResultPanel.UseConnectionOf seleted = (HqlResultPanel.UseConnectionOf)((Object)this._hqlResultPanel.cboUseConnectionOf.getSelectedItem());
        Props.putInt((String)PREF_KEY_USE_CONNECTION_OF, (int)seleted.ordinal());
    }

    private void onLimitRowsChanged() {
        if (this._hqlResultPanel.chkLimitObjectCount.isSelected()) {
            LimitObjectCountDialog locc = new LimitObjectCountDialog(Main.getApplication().getMainFrame());
            this._hqlResultPanel.chkLimitObjectCount.setSelected(locc.check());
            if (locc.checkAndRemember()) {
                Props.putBoolean((String)PREF_KEY_VIEW_LIMIT_OBJECT_COUNT, (boolean)true);
            }
        } else {
            Props.putBoolean((String)PREF_KEY_VIEW_LIMIT_OBJECT_COUNT, (boolean)false);
        }
        this._hqlResultPanel.nbrLimitRows.setEnabled(this._hqlResultPanel.chkLimitObjectCount.isSelected());
    }

    private void onSessionClosing() {
        Props.putInt((String)PREF_KEY_VIEW_LIMIT_OBJECT_COUNT_VAL, (int)this._hqlResultPanel.nbrLimitRows.getInt());
    }

    public JComponent getComponent() {
        return this._hqlResultPanel;
    }

    public void displayObjects(HibernateConnection con, String hqlQuery) {
        boolean limitObjectCount = this._hqlResultPanel.chkLimitObjectCount.isSelected();
        int limitObjectCountVal = this._hqlResultPanel.nbrLimitRows.getInt();
        boolean useSessionConnection = this._hqlResultPanel.cboUseConnectionOf.getSelectedItem() == HqlResultPanel.UseConnectionOf.OF_SESSION;
        this._objectResultController.displayObjects(con, hqlQuery, limitObjectCount, limitObjectCountVal, useSessionConnection);
    }
}

