/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dataimport;

import java.awt.Window;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.swing.Timer;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.dataimport.EDTMessageBoxUtil;
import net.sourceforge.squirrel_sql.plugins.dataimport.ImportProgressDialog;
import net.sourceforge.squirrel_sql.plugins.dataimport.importer.UnsupportedFormatException;

public class ImportProgressCtrl {
    private static final StringManager stringMgr = StringManagerFactory.getStringManager(ImportProgressCtrl.class);
    private static final ILogger log = LoggerController.createLogger(ImportProgressCtrl.class);
    private final ImportProgressDialog _dlg;
    private ITableInfo _table;
    private volatile int _currentRow;
    private volatile boolean _canceled;
    private final Timer _timer;

    public ImportProgressCtrl(ITableInfo table) {
        this._dlg = new ImportProgressDialog(table.getSimpleName());
        this._table = table;
        this._timer = new Timer(300, e -> this._dlg.txtNumberOfRowsImported.setText("" + this._currentRow));
        this._timer.setRepeats(true);
        this._timer.start();
        this._dlg.btnCancel.addActionListener(e -> this.onCanceled());
        GUIUtils.centerWithinParent((Window)this._dlg);
        this._dlg.setVisible(true);
    }

    private void onCanceled() {
        this._canceled = true;
    }

    public void setCurrentRow(int currentRow) {
        this._currentRow = currentRow;
    }

    public void finishedSuccessFully() {
        GUIUtils.processOnSwingEventThread(() -> this.close());
        EDTMessageBoxUtil.showMessageDialogOnEDT(stringMgr.getString("ImportDataIntoTableExecutor.inserted", new Object[]{this._currentRow, this._table.getSimpleName()}));
    }

    public void failedWithSQLException(SQLException sqle, PreparedStatement stmt) {
        GUIUtils.processOnSwingEventThread(() -> this.close());
        EDTMessageBoxUtil.showMessageDialogOnEDT(stringMgr.getString("ImportDataIntoTableExecutor.sqlException", new Object[]{sqle.getMessage(), Integer.toString(this._currentRow)}), stringMgr.getString("ImportDataIntoTableExecutor.error"));
        String query = stmt == null ? "null" : stmt.toString();
        log.error((Object)("Failing query: " + query));
        log.error((Object)("Failing line in CVS file: " + this._currentRow));
        log.error((Object)"Database error", (Throwable)sqle);
    }

    public void failedWithIoException(IOException ioe) {
        GUIUtils.processOnSwingEventThread(() -> this.close());
        EDTMessageBoxUtil.showMessageDialogOnEDT(stringMgr.getString("ImportDataIntoTableExecutor.ioException", new Object[]{ioe.getMessage(), this._currentRow}), stringMgr.getString("ImportDataIntoTableExecutor.error"));
        log.error((Object)"Error while reading file", (Throwable)ioe);
    }

    public void failedWithUnsupportedFormatException(UnsupportedFormatException ufe) {
        GUIUtils.processOnSwingEventThread(() -> this.close());
        EDTMessageBoxUtil.showMessageDialogOnEDT(stringMgr.getString("ImportDataIntoTableExecutor.UnsupportedFormatException", new Object[]{ufe.getMessage(), this._currentRow}), stringMgr.getString("ImportDataIntoTableExecutor.error"));
        log.error((Object)"Unsupported format.", (Throwable)ufe);
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    private void close() {
        this._timer.stop();
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }
}

