/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler.dependencies;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.springframework.boot.cli.compiler.dependencies.Dependency;
import org.springframework.boot.cli.compiler.dependencies.DependencyManagement;

public class MavenModelDependencyManagement
implements DependencyManagement {
    private final List<Dependency> dependencies;
    private final Map<String, Dependency> byArtifactId = new LinkedHashMap<String, Dependency>();

    public MavenModelDependencyManagement(Model model) {
        this.dependencies = MavenModelDependencyManagement.extractDependenciesFromModel(model);
        for (Dependency dependency : this.dependencies) {
            this.byArtifactId.put(dependency.getArtifactId(), dependency);
        }
    }

    private static List<Dependency> extractDependenciesFromModel(Model model) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (org.apache.maven.model.Dependency mavenDependency : model.getDependencyManagement().getDependencies()) {
            ArrayList<Dependency.Exclusion> exclusions = new ArrayList<Dependency.Exclusion>();
            for (Exclusion mavenExclusion : mavenDependency.getExclusions()) {
                exclusions.add(new Dependency.Exclusion(mavenExclusion.getGroupId(), mavenExclusion.getArtifactId()));
            }
            Dependency dependency = new Dependency(mavenDependency.getGroupId(), mavenDependency.getArtifactId(), mavenDependency.getVersion(), exclusions);
            dependencies.add(dependency);
        }
        return dependencies;
    }

    @Override
    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    @Override
    public String getSpringBootVersion() {
        return this.find("spring-boot").getVersion();
    }

    @Override
    public Dependency find(String artifactId) {
        return this.byArtifactId.get(artifactId);
    }
}

