/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springsource.loaded.ConstantPoolChecker2;
import org.springsource.loaded.Constants;
import org.springsource.loaded.GlobalConfiguration;
import org.springsource.loaded.ReloadableType;
import org.springsource.loaded.TypeRegistry;
import org.springsource.loaded.Utils;
import sl.org.objectweb.asm.ClassReader;
import sl.org.objectweb.asm.ClassVisitor;
import sl.org.objectweb.asm.ClassWriter;
import sl.org.objectweb.asm.FieldVisitor;
import sl.org.objectweb.asm.Handle;
import sl.org.objectweb.asm.Label;
import sl.org.objectweb.asm.MethodVisitor;
import sl.org.objectweb.asm.Opcodes;

public class MethodInvokerRewriter {
    private static Logger log = Logger.getLogger(MethodInvokerRewriter.class.getName());
    private static boolean anyNecessaryCacheCleanupDone = false;
    private static Map<String, Boolean> cacheIndex = null;
    private static final boolean DEBUG_CACHING;
    private static final int CACHE_VERSION_1_1_0 = 1;
    private static final int CACHE_VERSION_1_1_1 = 2;
    private static final int CURRENT_CACHE_VERSION = 2;
    private static boolean versionInIndex;

    public static byte[] rewrite(TypeRegistry typeRegistry, byte[] bytes, boolean skipReferencesCheck) {
        MethodInvokerRewriter.ensureCleanupDone();
        return MethodInvokerRewriter.rewrite(false, typeRegistry, bytes, skipReferencesCheck);
    }

    public static byte[] rewrite(TypeRegistry typeRegistry, byte[] bytes) {
        MethodInvokerRewriter.ensureCleanupDone();
        return MethodInvokerRewriter.rewrite(false, typeRegistry, bytes, true);
    }

    public static byte[] rewriteUsingCache(String slashedClassName, TypeRegistry typeRegistry, byte[] bytes) {
        MethodInvokerRewriter.ensureCacheIndexLoaded();
        if (DEBUG_CACHING) {
            System.out.println("cache check for " + slashedClassName);
        }
        if (slashedClassName != null) {
            String cachekey = slashedClassName + "_" + bytes.length;
            Boolean b = cacheIndex.get(cachekey);
            if (DEBUG_CACHING) {
                System.out.println("was in index? " + b);
            }
            if (b != null) {
                if (b.booleanValue()) {
                    String cacheFileName = slashedClassName.replace('/', '_') + "_" + bytes.length + ".bytes";
                    File cacheFile = new File(GlobalConfiguration.cacheDir, ".slcache" + File.separator + cacheFileName);
                    if (DEBUG_CACHING) {
                        System.out.println("Checking for cache file " + cacheFile);
                    }
                    if (cacheFile.exists()) {
                        if (DEBUG_CACHING) {
                            System.out.println("loading and returning cached file contents");
                        }
                        try {
                            FileInputStream fis = new FileInputStream(cacheFile);
                            byte[] cachedBytes = Utils.loadBytesFromStream(fis);
                            return cachedBytes;
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                } else {
                    if (DEBUG_CACHING) {
                        System.out.println("returning unmodified bytes, no need to change");
                    }
                    return bytes;
                }
            }
        }
        if (DEBUG_CACHING) {
            System.out.println("modifying " + slashedClassName);
        }
        return MethodInvokerRewriter.rewrite(true, typeRegistry, bytes, false);
    }

    private static void recursiveDelete(File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File f : files) {
                MethodInvokerRewriter.recursiveDelete(f);
            }
        }
        boolean d = file.delete();
        if (DEBUG_CACHING) {
            System.out.println("Deleting " + file + " " + d);
        }
    }

    private static void ensureCleanupDone() {
        if (anyNecessaryCacheCleanupDone) {
            return;
        }
        if (GlobalConfiguration.cleanCache) {
            MethodInvokerRewriter.deleteCacheFiles();
        }
        anyNecessaryCacheCleanupDone = true;
    }

    private static void deleteCacheFiles() {
        File cacheDir = new File(GlobalConfiguration.cacheDir, ".slcache");
        if (cacheDir.exists()) {
            MethodInvokerRewriter.recursiveDelete(cacheDir);
            if (cacheIndex != null) {
                cacheIndex.clear();
            }
        }
        versionInIndex = false;
    }

    private static void ensureCacheIndexLoaded() {
        if (cacheIndex == null) {
            cacheIndex = new HashMap<String, Boolean>();
            if (GlobalConfiguration.cleanCache) {
                MethodInvokerRewriter.deleteCacheFiles();
                anyNecessaryCacheCleanupDone = true;
            } else {
                File cacheDir = new File(GlobalConfiguration.cacheDir, ".slcache");
                cacheDir.mkdir();
                File cacheIndexFile = new File(cacheDir, ".index");
                if (cacheIndexFile.exists()) {
                    try {
                        boolean clearCache = false;
                        int cacheVersion = 1;
                        try {
                            String line;
                            FileReader fr = new FileReader(cacheIndexFile);
                            BufferedReader br = new BufferedReader(fr);
                            boolean handledVersionString = false;
                            while ((line = br.readLine()) != null) {
                                if (!handledVersionString && line.startsWith("Version")) {
                                    int colon = line.indexOf(":");
                                    if (colon != -1) {
                                        cacheVersion = Integer.parseInt(line.substring(colon + 1));
                                    }
                                    handledVersionString = true;
                                    continue;
                                }
                                StringTokenizer st = new StringTokenizer(line, ":");
                                boolean changed = st.nextToken().equals("y");
                                String len = st.nextToken();
                                String classname = st.nextToken();
                                String key = classname + "_" + len;
                                cacheIndex.put(key, changed);
                            }
                            fr.close();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                        if (cacheVersion != 2) {
                            clearCache = true;
                            versionInIndex = false;
                        } else {
                            versionInIndex = true;
                        }
                        if (clearCache) {
                            if (DEBUG_CACHING) {
                                System.out.println("SpringLoaded: cache looks old (version " + cacheVersion + ") - clearing it");
                            }
                            MethodInvokerRewriter.deleteCacheFiles();
                            anyNecessaryCacheCleanupDone = true;
                        }
                    }
                    catch (NoSuchElementException nsme) {
                        if (DEBUG_CACHING) {
                            System.out.println("SpringLoaded: cache corrupt, clearing it");
                        }
                        MethodInvokerRewriter.deleteCacheFiles();
                        anyNecessaryCacheCleanupDone = true;
                    }
                }
            }
        }
    }

    private static byte[] rewrite(boolean canCache, TypeRegistry typeRegistry, byte[] bytes, boolean skipReferencesCheck) {
        if (!skipReferencesCheck) {
            ConstantPoolChecker2.References refs = ConstantPoolChecker2.getReferences(bytes);
            boolean needsRewriting = false;
            for (String clazz : refs.referencedClasses) {
                if (typeRegistry != null && typeRegistry.isReloadableTypeName(clazz)) {
                    needsRewriting = true;
                    break;
                }
                if (clazz.length() <= 10 || clazz.charAt(0) != 'j' || !clazz.startsWith("java/lang/reflect/") && !clazz.equals("java/lang/Class")) continue;
                boolean foundMethodCandidate = false;
                for (String classPlusMethod : refs.referencedMethods) {
                    if (!RewriteClassAdaptor.intercepted.contains(classPlusMethod)) continue;
                    foundMethodCandidate = true;
                    break;
                }
                if (!foundMethodCandidate) continue;
                needsRewriting = true;
                break;
            }
            if (!needsRewriting) {
                MethodInvokerRewriter.addToCacheIndex(refs.slashedClassName, bytes, false);
                return bytes;
            }
        }
        ClassReader fileReader = new ClassReader(bytes);
        RewriteClassAdaptor classAdaptor = new RewriteClassAdaptor(typeRegistry);
        try {
            fileReader.accept(classAdaptor, 4);
        }
        catch (DontRewriteException drex) {
            return bytes;
        }
        byte[] bs = classAdaptor.getBytes();
        if (canCache && classAdaptor.rewroteReflection && !classAdaptor.rewroteOtherKindOfOperation && GlobalConfiguration.isCaching && !classAdaptor.slashedclassname.startsWith("com/sun/proxy/$Proxy")) {
            MethodInvokerRewriter.cacheOnDisk(classAdaptor.slashedclassname, bytes, bs);
        }
        return bs;
    }

    private static synchronized void cacheOnDisk(String slashedclassname, byte[] originalBytes, byte[] newbytes) {
        if (!GlobalConfiguration.isCaching) {
            return;
        }
        File cacheDir = new File(GlobalConfiguration.cacheDir, ".slcache");
        cacheDir.mkdir();
        File cacheFile = new File(cacheDir, slashedclassname.replace('/', '_') + "_" + originalBytes.length + ".bytes");
        if (DEBUG_CACHING) {
            System.out.println("Caching " + slashedclassname + " in " + cacheFile);
        }
        try {
            FileOutputStream fos = new FileOutputStream(cacheFile);
            fos.write(newbytes, 0, newbytes.length);
            fos.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        MethodInvokerRewriter.addToCacheIndex(slashedclassname, originalBytes, true);
    }

    private static void addToCacheIndex(String slashedclassname, byte[] bytes, boolean changed) {
        if (!GlobalConfiguration.isCaching) {
            return;
        }
        File cacheDir = new File(GlobalConfiguration.cacheDir, ".slcache");
        cacheDir.mkdir();
        File cacheIndexFile = new File(cacheDir, ".index");
        try {
            FileWriter fw = new FileWriter(cacheIndexFile, true);
            BufferedWriter bw = new BufferedWriter(fw);
            if (!versionInIndex) {
                versionInIndex = true;
                bw.write("Version:2\n");
            }
            bw.write((changed ? "y" : "n") + ":" + bytes.length + ":" + slashedclassname + "\n");
            bw.flush();
            fw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static void checkNotTheSame(byte[] bs, byte[] bytes) {
        if (bs.length == bytes.length) {
            System.out.println("same length!");
            boolean same = true;
            for (int i = 0; i < bs.length; ++i) {
                if (bs[i] == bytes[i]) continue;
                same = false;
                break;
            }
            if (same) {
                System.out.println("same data!!");
            } else {
                System.out.println("diff data");
            }
        } else {
            System.out.println("different");
        }
    }

    static {
        boolean b = false;
        try {
            b = System.getProperty("springloaded.debugcaching", "false").equalsIgnoreCase("true");
        }
        catch (Exception exception) {
            // empty catch block
        }
        DEBUG_CACHING = b;
        versionInIndex = false;
    }

    static class RewriteClassAdaptor
    extends ClassVisitor
    implements Opcodes {
        private ClassVisitor cw = this.cv;
        static final String[] ignored = new String[]{"Array.", "GenericArrayType.", "InvocationTargetException.", "MalformedParameterizedTypeException.", "Modifier.", "ParameterizedType.", "UndeclaredThrowableException.", "WildcardType.", "TypeVariable.", "AccessibleObject.isAccessible", "AccessibleObject.setAccessible", "Class.asSubclass", "Class.cast", "Class.forName", "Class.getCanonicalName", "Class.getClassLoader", "Class.getClasses", "Class.getComponentType", "Class.getDeclaredClasses", "Class.getDeclaringClass", "Class.getEnclosingClass", "Class.getEnclosingConstructor", "Class.getEnclosingMethod", "Class.getGenericInterfaces", "Class.getGenericSuperclass", "Class.desiredAssertionStatus", "Class.getEnumConstants", "Class.getInterfaces", "Class.getModifiers", "Class.getName", "Class.getPackage", "Class.getProtectionDomain", "Class.getResourceAsStream", "Class.getResource", "Class.getSuperclass", "Class.getSimpleName", "Class.getSigners", "Class.getTypeParameters", "Class.isArray", "Class.isAnonymousClass", "Class.isAnnotation", "Class.isAssignableFrom", "Class.isEnum", "Class.isInstance", "Class.isInterface", "Class.isLocalClass", "Class.isMemberClass", "Class.isPrimitive", "Class.isSynthetic", "Class.toString", "Constructor.equals", "Constructor.toString", "Constructor.hashCode", "Constructor.getModifiers", "Constructor.getName", "Constructor.getDeclaringClass", "Constructor.getParameterTypes", "Constructor.getTypeParameters", "Constructor.isSynthetic", "Constructor.toGenericString", "Constructor.getExceptionTypes", "Constructor.getGenericExceptionTypes", "Constructor.getGenericParameterTypes", "Constructor.isVarArgs", "Field.equals", "Field.getDeclaringClass", "Field.getGenericType", "Field.getName", "Field.getModifiers", "Field.getType", "Field.hashCode", "Field.isEnumConstant", "Field.isSynthetic", "Field.toGenericString", "Field.toString", "Member.getDeclaringClass", "Member.getModifiers", "Member.getName", "Method.equals", "Method.getDeclaringClass", "Method.getDefaultValue", "Method.getGenericExceptionTypes", "Method.getGenericParameterTypes", "Method.getGenericReturnType", "Method.getExceptionTypes", "Method.getModifiers", "Method.getName", "Method.getParameterTypes", "Method.getReturnType", "Method.getTypeParameters", "Method.hashCode", "Method.isAccessible", "Method.isBridge", "Method.isSynthetic", "Method isVarArgs", "Method.setAccessible", "Method toGenericString", "Method.toString"};
        private String slashedclassname;
        static final HashSet<String> intercepted = new HashSet();
        public boolean rewroteReflection = false;
        public boolean rewroteOtherKindOfOperation = false;
        public boolean thisClassIsReloadable = false;
        protected TypeRegistry typeRegistry;
        boolean isEnum = false;
        private boolean isGroovyClosure = false;
        int fieldcount = 0;
        private ReloadableType rtype;

        private static void interceptable(String owner, String methodName) {
            String k = owner + "." + methodName;
            if (intercepted.contains(k)) {
                throw new IllegalStateException("Attempt to add duplicate entry " + k);
            }
            intercepted.add(k);
        }

        private static boolean isInterceptable(String owner, String methodName) {
            return intercepted.contains(owner + "." + methodName);
        }

        public RewriteClassAdaptor(TypeRegistry typeRegistry, ClassVisitor classWriter) {
            super(327680, classWriter);
            this.typeRegistry = typeRegistry;
        }

        public RewriteClassAdaptor(TypeRegistry typeRegistry) {
            this(typeRegistry, (ClassVisitor)new ClassWriter(1));
        }

        public byte[] getBytes() {
            byte[] bytes = ((ClassWriter)this.cw).toByteArray();
            return bytes;
        }

        public ClassVisitor getClassVisitor() {
            return this.cv;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.slashedclassname = name;
            boolean bl = this.thisClassIsReloadable = this.typeRegistry != null && this.typeRegistry.isReloadableTypeName(this.slashedclassname);
            if (this.slashedclassname.startsWith("org/springsource/loaded/")) {
                throw new DontRewriteException();
            }
            if (superName.equals("java/lang/Enum")) {
                this.isEnum = true;
            } else if (superName.equals("groovy/lang/Closure")) {
                this.isGroovyClosure = true;
            }
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            ++this.fieldcount;
            return super.visitField(access, name, desc, signature, value);
        }

        public MethodVisitor visitMethod(int flags, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(flags, name, descriptor, signature, exceptions);
            return new RewritingMethodAdapter(mv, name);
        }

        static {
            RewriteClassAdaptor.interceptable("java/lang/reflect/AccessibleObject", "getAnnotation");
            RewriteClassAdaptor.interceptable("java/lang/reflect/AccessibleObject", "getAnnotations");
            RewriteClassAdaptor.interceptable("java/lang/reflect/AccessibleObject", "getDeclaredAnnotations");
            RewriteClassAdaptor.interceptable("java/lang/reflect/AccessibleObject", "isAnnotationPresent");
            RewriteClassAdaptor.interceptable("java/lang/reflect/AnnotatedElement", "getAnnotation");
            RewriteClassAdaptor.interceptable("java/lang/reflect/AnnotatedElement", "getAnnotations");
            RewriteClassAdaptor.interceptable("java/lang/reflect/AnnotatedElement", "getDeclaredAnnotations");
            RewriteClassAdaptor.interceptable("java/lang/reflect/AnnotatedElement", "isAnnotationPresent");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Method", "getAnnotation");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Method", "getAnnotations");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Method", "getDeclaredAnnotations");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Method", "getParameterAnnotations");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Method", "invoke");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Method", "isAnnotationPresent");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Constructor", "getAnnotation");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Constructor", "getAnnotations");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Constructor", "getDeclaredAnnotations");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Constructor", "getParameterAnnotations");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Constructor", "isAnnotationPresent");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Constructor", "newInstance");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Field", "getAnnotation");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Field", "getAnnotations");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Field", "getDeclaredAnnotations");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Field", "isAnnotationPresent");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Field", "get");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Field", "getBoolean");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Field", "getByte");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Field", "getShort");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Field", "getChar");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Field", "getInt");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Field", "getLong");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Field", "getFloat");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Field", "getDouble");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Field", "set");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Field", "setBoolean");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Field", "setByte");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Field", "setChar");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Field", "setDouble");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Field", "setFloat");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Field", "setInt");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Field", "setLong");
            RewriteClassAdaptor.interceptable("java/lang/reflect/Field", "setShort");
            RewriteClassAdaptor.interceptable("java/lang/Class", "getAnnotation");
            RewriteClassAdaptor.interceptable("java/lang/Class", "getAnnotations");
            RewriteClassAdaptor.interceptable("java/lang/Class", "getField");
            RewriteClassAdaptor.interceptable("java/lang/Class", "getFields");
            RewriteClassAdaptor.interceptable("java/lang/Class", "getDeclaredAnnotations");
            RewriteClassAdaptor.interceptable("java/lang/Class", "getConstructors");
            RewriteClassAdaptor.interceptable("java/lang/Class", "getConstructor");
            RewriteClassAdaptor.interceptable("java/lang/Class", "getDeclaredConstructors");
            RewriteClassAdaptor.interceptable("java/lang/Class", "getDeclaredConstructor");
            RewriteClassAdaptor.interceptable("java/lang/Class", "getDeclaredField");
            RewriteClassAdaptor.interceptable("java/lang/Class", "getDeclaredFields");
            RewriteClassAdaptor.interceptable("java/lang/Class", "getDeclaredMethod");
            RewriteClassAdaptor.interceptable("java/lang/Class", "getDeclaredMethods");
            RewriteClassAdaptor.interceptable("java/lang/Class", "getMethod");
            RewriteClassAdaptor.interceptable("java/lang/Class", "getMethods");
            RewriteClassAdaptor.interceptable("java/lang/Class", "getModifiers");
            RewriteClassAdaptor.interceptable("java/lang/Class", "isAnnotationPresent");
            RewriteClassAdaptor.interceptable("java/lang/Class", "newInstance");
        }

        class RewritingMethodAdapter
        extends MethodVisitor
        implements Opcodes,
        Constants {
            private int max;
            private String methodname;
            private boolean isClinitOrEnumInit;
            int unitializedObjectsCount;

            public RewritingMethodAdapter(MethodVisitor mv, String methodname) {
                super(327680, mv);
                this.max = 0;
                this.isClinitOrEnumInit = false;
                this.unitializedObjectsCount = 0;
                this.methodname = methodname;
                if (RewriteClassAdaptor.this.isEnum) {
                    boolean bl = this.isClinitOrEnumInit = this.methodname.length() > 2 && this.methodname.charAt(0) == '<' && this.methodname.charAt(1) == 'c';
                    if (!this.isClinitOrEnumInit) {
                        this.isClinitOrEnumInit = this.methodname.startsWith(" enum constant initialization");
                    }
                }
            }

            public void visitVarInsn(int opcode, int var) {
                if (var > this.max) {
                    this.max = opcode == 22 || opcode == 24 || opcode == 55 || opcode == 57 ? var + 1 : var;
                } else if (var == this.max && (opcode == 22 || opcode == 24 || opcode == 55 || opcode == 57)) {
                    this.max = var + 1;
                }
                super.visitVarInsn(opcode, var);
            }

            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                boolean isReloadable;
                boolean bl = RewriteClassAdaptor.this.typeRegistry != null && (owner.equals(RewriteClassAdaptor.this.slashedclassname) ? RewriteClassAdaptor.this.thisClassIsReloadable : RewriteClassAdaptor.this.typeRegistry.isReloadableTypeName(owner)) ? true : (isReloadable = false);
                if (!isReloadable) {
                    super.visitFieldInsn(opcode, owner, name, desc);
                    return;
                }
                if (opcode == 178) {
                    if (name.equals("$callSiteArray") || name.equals("$staticClassInfo")) {
                        super.visitFieldInsn(opcode, owner, name, desc);
                        return;
                    }
                    if (RewriteClassAdaptor.this.isEnum && this.isClinitOrEnumInit && RewriteClassAdaptor.this.fieldcount > GlobalConfiguration.enumLimit) {
                        super.visitFieldInsn(opcode, owner, name, desc);
                        return;
                    }
                    this.rewriteGETSTATIC(opcode, owner, name, desc);
                } else if (opcode == 179) {
                    if (RewriteClassAdaptor.this.isEnum && this.isClinitOrEnumInit && RewriteClassAdaptor.this.fieldcount > GlobalConfiguration.enumLimit) {
                        super.visitFieldInsn(opcode, owner, name, desc);
                        return;
                    }
                    this.rewritePUTSTATIC(opcode, owner, name, desc);
                } else if (opcode == 180) {
                    this.rewriteGETFIELD(opcode, owner, name, desc);
                } else if (opcode == 181) {
                    this.rewritePUTFIELD(opcode, owner, name, desc);
                }
                RewriteClassAdaptor.this.rewroteOtherKindOfOperation = true;
            }

            private void rewritePUTFIELD(int opcode, String owner, String name, String desc) {
                int classId = RewriteClassAdaptor.this.typeRegistry.getTypeIdFor(owner, true);
                this.mv.visitLdcInsn(Utils.toCombined(RewriteClassAdaptor.this.typeRegistry.getId(), classId));
                this.mv.visitLdcInsn(name);
                this.mv.visitMethodInsn(184, "org/springsource/loaded/TypeRegistry", "instanceFieldInterceptionRequired", "(ILjava/lang/String;)Z", false);
                Label l1 = new Label();
                this.mv.visitJumpInsn(153, l1);
                Utils.insertBoxInsns(this.mv, desc);
                this.mv.visitInsn(95);
                this.mv.visitInsn(90);
                this.mv.visitLdcInsn(name);
                this.mv.visitMethodInsn(183, owner, "r$set", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;)V", false);
                Label l2 = new Label();
                this.mv.visitJumpInsn(167, l2);
                this.mv.visitLabel(l1);
                super.visitFieldInsn(opcode, owner, name, desc);
                this.mv.visitLabel(l2);
            }

            private void rewriteGETFIELD(int opcode, String owner, String name, String desc) {
                int classId = RewriteClassAdaptor.this.typeRegistry.getTypeIdFor(owner, true);
                this.mv.visitLdcInsn(Utils.toCombined(RewriteClassAdaptor.this.typeRegistry.getId(), classId));
                this.mv.visitLdcInsn(name);
                this.mv.visitMethodInsn(184, "org/springsource/loaded/TypeRegistry", "instanceFieldInterceptionRequired", "(ILjava/lang/String;)Z", false);
                Label l1 = new Label();
                this.mv.visitJumpInsn(153, l1);
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn(name);
                this.mv.visitMethodInsn(183, owner, "r$get", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", false);
                if (desc.length() != 1) {
                    if (!desc.equals("java/lang/Object")) {
                        this.mv.visitTypeInsn(192, this.toDescriptor(desc));
                    }
                } else {
                    Utils.insertUnboxInsns(this.mv, desc.charAt(0), true);
                }
                Label l2 = new Label();
                this.mv.visitJumpInsn(167, l2);
                this.mv.visitLabel(l1);
                super.visitFieldInsn(opcode, owner, name, desc);
                this.mv.visitLabel(l2);
            }

            private void rewritePUTSTATIC(int opcode, String owner, String name, String desc) {
                int classId = RewriteClassAdaptor.this.typeRegistry.getTypeIdFor(owner, true);
                this.mv.visitLdcInsn(Utils.toCombined(RewriteClassAdaptor.this.typeRegistry.getId(), classId));
                this.mv.visitLdcInsn(name);
                this.mv.visitMethodInsn(184, "org/springsource/loaded/TypeRegistry", "staticFieldInterceptionRequired", "(ILjava/lang/String;)Z", false);
                Label l1 = new Label();
                this.mv.visitJumpInsn(153, l1);
                Utils.insertBoxInsns(this.mv, desc);
                this.mv.visitLdcInsn(name);
                this.mv.visitMethodInsn(184, owner, "r$sets", "(Ljava/lang/Object;Ljava/lang/String;)V", false);
                Label l2 = new Label();
                this.mv.visitJumpInsn(167, l2);
                this.mv.visitLabel(l1);
                super.visitFieldInsn(opcode, owner, name, desc);
                this.mv.visitLabel(l2);
            }

            private void rewriteGETSTATIC(int opcode, String owner, String name, String desc) {
                int classId = RewriteClassAdaptor.this.typeRegistry.getTypeIdFor(owner, true);
                this.mv.visitLdcInsn(Utils.toCombined(RewriteClassAdaptor.this.typeRegistry.getId(), classId));
                this.mv.visitLdcInsn(name);
                this.mv.visitMethodInsn(184, "org/springsource/loaded/TypeRegistry", "staticFieldInterceptionRequired", "(ILjava/lang/String;)Z", false);
                Label l1 = new Label();
                this.mv.visitJumpInsn(153, l1);
                this.mv.visitLdcInsn(name);
                this.mv.visitMethodInsn(184, owner, "r$gets", "(Ljava/lang/String;)Ljava/lang/Object;", false);
                if (desc.length() != 1) {
                    if (!desc.equals("java/lang/Object")) {
                        this.mv.visitTypeInsn(192, this.toDescriptor(desc));
                    }
                } else {
                    Utils.insertUnboxInsnsIfNecessary(this.mv, desc, true);
                }
                Label l2 = new Label();
                this.mv.visitJumpInsn(167, l2);
                this.mv.visitLabel(l1);
                super.visitFieldInsn(opcode, owner, name, desc);
                this.mv.visitLabel(l2);
            }

            private String toDescriptor(String longDescriptor) {
                if (longDescriptor.charAt(0) == '[') {
                    return longDescriptor;
                }
                return longDescriptor.substring(1, longDescriptor.length() - 1);
            }

            private boolean interceptReflection(String owner, String name, String desc) {
                if (RewriteClassAdaptor.isInterceptable(owner, name)) {
                    this.callReflectiveInterceptor(owner, name, desc, this.mv);
                    return true;
                }
                return false;
            }

            public void visitTypeInsn(int opcode, String type) {
                if (opcode == 187) {
                    ++this.unitializedObjectsCount;
                }
                super.visitTypeInsn(opcode, type);
            }

            private String toString(Handle handle) {
                return "handle(tag=" + handle.getTag() + ",name=" + handle.getName() + ",desc=" + handle.getDesc() + ",owner=" + handle.getOwner();
            }

            private String toString(Object[] oa) {
                StringBuilder buf = new StringBuilder();
                buf.append("[");
                if (oa != null) {
                    for (Object o : oa) {
                        buf.append(" ");
                        buf.append(o);
                    }
                }
                buf.append("]");
                return buf.toString();
            }

            boolean hasParams(String descriptor) {
                return descriptor.charAt(1) != ')';
            }

            private void stackParameters(String descriptor) {
                if (this.hasParams(descriptor)) {
                    Utils.collapseStackToArray(this.mv, descriptor);
                } else {
                    this.mv.visitInsn(1);
                }
            }

            public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
                int classId = RewriteClassAdaptor.this.typeRegistry.getTypeIdFor(RewriteClassAdaptor.this.slashedclassname, true);
                if (classId == -1) {
                    throw new IllegalStateException("Unable to find classId for " + RewriteClassAdaptor.this.slashedclassname + " referenced from invokedynamic in " + this.methodname + "()");
                }
                if (RewriteClassAdaptor.this.typeRegistry.getReloadableType(classId) == null) {
                    super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
                    return;
                }
                if (bsm.getTag() == 6 && bsm.getName().equals("metafactory") && bsm.getOwner().equals("java/lang/invoke/LambdaMetafactory")) {
                    this.mv.visitMethodInsn(184, "org/springsource/loaded/TypeRegistry", "idycheck", "()Ljava/lang/Object;", false);
                    Label nochange = new Label();
                    this.mv.visitJumpInsn(198, nochange);
                    this.stackParameters(desc);
                    int bsmReferenceId = RewriteClassAdaptor.this.typeRegistry.recordBootstrapMethod(RewriteClassAdaptor.this.slashedclassname, bsm, bsmArgs);
                    this.mv.visitLdcInsn(RewriteClassAdaptor.this.typeRegistry.getId());
                    this.mv.visitLdcInsn(classId);
                    this.mv.visitMethodInsn(184, "java/lang/invoke/MethodHandles", "lookup", "()Ljava/lang/invoke/MethodHandles$Lookup;", false);
                    this.mv.visitLdcInsn(name + desc);
                    this.mv.visitLdcInsn(bsmReferenceId);
                    this.mv.visitMethodInsn(184, "org/springsource/loaded/TypeRegistry", "idyrun", "([Ljava/lang/Object;IILjava/lang/Object;Ljava/lang/String;I)Ljava/lang/Object;", false);
                    Label gotolabel = new Label();
                    this.mv.visitJumpInsn(167, gotolabel);
                    this.mv.visitLabel(nochange);
                    super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
                    this.mv.visitLabel(gotolabel);
                } else {
                    if (GlobalConfiguration.verboseMode && log.isLoggable(Level.WARNING)) {
                        log.warning("[current limitation] not rewriting invokedynamic usage in type '" + RewriteClassAdaptor.this.slashedclassname + "'. InvokeDynamic(name=" + name + ",desc=" + desc + ",bsm=" + this.toString(bsm) + ",bsmArgs=" + this.toString(bsmArgs));
                    }
                    super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
                }
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                boolean isReloadable;
                if (this.rewriteReflectiveCall(opcode, owner, name, desc)) {
                    return;
                }
                if (opcode == 183) {
                    --this.unitializedObjectsCount;
                }
                if (name.equals("$getCallSiteArray")) {
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                    return;
                }
                boolean bl = RewriteClassAdaptor.this.typeRegistry != null && (owner.equals(RewriteClassAdaptor.this.slashedclassname) ? RewriteClassAdaptor.this.thisClassIsReloadable : RewriteClassAdaptor.this.typeRegistry.isReloadableTypeName(owner)) ? true : (isReloadable = false);
                if (!isReloadable) {
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                    return;
                }
                RewriteClassAdaptor.this.rewroteOtherKindOfOperation = true;
                boolean hasParams = desc.charAt(1) != ')';
                Utils.ReturnType returnType = Utils.getReturnTypeDescriptor(desc);
                int classId = RewriteClassAdaptor.this.typeRegistry.getTypeIdFor(owner, true);
                if (opcode == 184) {
                    this.rewriteINVOKESTATIC(opcode, owner, name, desc, hasParams, returnType, classId, itf);
                } else if (opcode == 185) {
                    this.rewriteINVOKEINTERFACE(opcode, owner, name, desc, hasParams, returnType, classId, itf);
                } else if (opcode == 182) {
                    this.rewriteINVOKEVIRTUAL(opcode, owner, name, desc, hasParams, returnType, classId, itf);
                } else if (opcode == 183) {
                    this.rewriteINVOKESPECIAL(opcode, owner, name, desc, hasParams, returnType, classId, itf);
                } else {
                    Utils.logAndThrow(log, "Failed to rewrite instruction " + Utils.toOpcodeString(opcode) + " in method " + this.methodname);
                }
            }

            private boolean rewriteReflectiveCall(int opcode, String owner, String name, String desc) {
                boolean rewritten;
                return owner.length() > 10 && owner.charAt(0) == 'j' && (owner.startsWith("java/lang/reflect/") || owner.equals("java/lang/Class")) && (rewritten = this.interceptReflection(owner, name, desc));
            }

            private void rewriteINVOKESTATIC(int opcode, String owner, String name, String desc, boolean hasParams, Utils.ReturnType returnType, int classId, boolean itf) {
                this.mv.visitLdcInsn(Utils.toCombined(RewriteClassAdaptor.this.typeRegistry.getId(), classId));
                this.mv.visitLdcInsn(name + desc);
                this.mv.visitMethodInsn(184, "org/springsource/loaded/TypeRegistry", "istcheck", "(ILjava/lang/String;)Ljava/lang/Object;", false);
                this.mv.visitInsn(89);
                Label l1 = new Label();
                this.mv.visitJumpInsn(198, l1);
                this.mv.visitTypeInsn(192, Utils.getInterfaceName(owner));
                this.mv.visitVarInsn(58, this.max + 1);
                if (hasParams) {
                    Utils.collapseStackToArray(this.mv, desc);
                }
                if (!hasParams) {
                    this.mv.visitVarInsn(25, this.max + 1);
                    this.mv.visitInsn(1);
                    this.mv.visitInsn(1);
                } else {
                    this.mv.visitVarInsn(25, this.max + 1);
                    this.mv.visitInsn(95);
                    this.mv.visitInsn(1);
                }
                this.mv.visitLdcInsn(name + desc);
                this.mv.visitMethodInsn(185, Utils.getInterfaceName(owner), "__execute", "([Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", true);
                this.insertAppropriateReturn(returnType);
                Label gotolabel = new Label();
                this.mv.visitJumpInsn(167, gotolabel);
                this.mv.visitLabel(l1);
                this.mv.visitInsn(87);
                super.visitMethodInsn(opcode, owner, name, desc, itf);
                this.mv.visitLabel(gotolabel);
            }

            private void insertAppropriateReturn(Utils.ReturnType returnType) {
                if (returnType.isVoid()) {
                    this.mv.visitInsn(87);
                } else if (returnType.isPrimitive()) {
                    Utils.insertUnboxInsnsIfNecessary(this.mv, returnType.descriptor, true);
                } else {
                    this.mv.visitTypeInsn(192, returnType.descriptor);
                }
            }

            private void rewriteINVOKEINTERFACE(int opcode, String owner, String name, String desc, boolean hasParams, Utils.ReturnType returnType, int classId, boolean itf) {
                this.mv.visitLdcInsn(Utils.toCombined(RewriteClassAdaptor.this.typeRegistry.getId(), classId));
                this.mv.visitLdcInsn(name + desc);
                this.mv.visitMethodInsn(184, "org/springsource/loaded/TypeRegistry", "iincheck", "(ILjava/lang/String;)Z", false);
                Label l1 = new Label();
                this.mv.visitJumpInsn(153, l1);
                if (hasParams) {
                    Utils.collapseStackToArray(this.mv, desc);
                }
                if (!hasParams) {
                    this.mv.visitInsn(89);
                    this.mv.visitInsn(1);
                    this.mv.visitInsn(95);
                } else {
                    this.mv.visitInsn(95);
                    this.mv.visitInsn(90);
                }
                this.mv.visitLdcInsn(name + desc);
                if (GlobalConfiguration.isJava18orHigher) {
                    this.mv.visitMethodInsn(184, "org/springsource/loaded/TypeRegistry", "iiIntercept", "(Ljava/lang/Object;[Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", false);
                } else {
                    this.mv.visitMethodInsn(185, owner, "__execute", "([Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", true);
                }
                this.insertAppropriateReturn(returnType);
                Label gotolabel = new Label();
                this.mv.visitJumpInsn(167, gotolabel);
                this.mv.visitLabel(l1);
                super.visitMethodInsn(opcode, owner, name, desc, true);
                this.mv.visitLabel(gotolabel);
            }

            private void rewriteINVOKEVIRTUAL(int opcode, String owner, String name, String desc, boolean hasParams, Utils.ReturnType returnType, int classId, boolean itf) {
                this.mv.visitLdcInsn(Utils.toCombined(RewriteClassAdaptor.this.typeRegistry.getId(), classId));
                this.mv.visitLdcInsn(name + desc);
                this.mv.visitMethodInsn(184, "org/springsource/loaded/TypeRegistry", "ivicheck", "(ILjava/lang/String;)Z", false);
                Label l1 = new Label();
                this.mv.visitJumpInsn(153, l1);
                if (hasParams) {
                    Utils.collapseStackToArray(this.mv, desc);
                }
                if (!hasParams) {
                    this.mv.visitInsn(89);
                    this.mv.visitInsn(1);
                    this.mv.visitInsn(95);
                } else {
                    this.mv.visitInsn(95);
                    this.mv.visitInsn(90);
                }
                this.mv.visitLdcInsn(name + desc);
                this.mv.visitMethodInsn(182, owner, "__execute", "([Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", itf);
                this.insertAppropriateReturn(returnType);
                Label gotolabel = new Label();
                this.mv.visitJumpInsn(167, gotolabel);
                this.mv.visitLabel(l1);
                super.visitMethodInsn(opcode, owner, name, desc, itf);
                this.mv.visitLabel(gotolabel);
            }

            private void rewriteINVOKESPECIAL(int opcode, String owner, String name, String desc, boolean hasParams, Utils.ReturnType returnType, int classId, boolean itf) {
                if (this.unitializedObjectsCount == -1 && name.charAt(0) == '<') {
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                    return;
                }
                if (!name.equals("<init>") && owner.equals(RewriteClassAdaptor.this.slashedclassname)) {
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                    return;
                }
                if (name.charAt(0) == '<') {
                    if (RewriteClassAdaptor.this.isEnum && this.isClinitOrEnumInit && RewriteClassAdaptor.this.fieldcount > GlobalConfiguration.enumLimit && owner.equals(RewriteClassAdaptor.this.slashedclassname)) {
                        super.visitMethodInsn(opcode, owner, name, desc, itf);
                        return;
                    }
                    this.mv.visitLdcInsn(Utils.toCombined(RewriteClassAdaptor.this.typeRegistry.getId(), classId));
                    this.mv.visitLdcInsn(desc);
                    this.mv.visitMethodInsn(184, "org/springsource/loaded/TypeRegistry", "ccheck", "(ILjava/lang/String;)Ljava/lang/Object;", false);
                    this.mv.visitInsn(89);
                    Label l1 = new Label();
                    this.mv.visitJumpInsn(198, l1);
                    this.mv.visitTypeInsn(192, "org/springsource/loaded/__DynamicallyDispatchable");
                    this.mv.visitVarInsn(58, this.max + 1);
                    if (hasParams) {
                        boolean selfEnumCall = owner.equals(RewriteClassAdaptor.this.slashedclassname) && RewriteClassAdaptor.this.isEnum;
                        Utils.collapseStackToArray(this.mv, desc);
                        this.mv.visitInsn(95);
                        this.mv.visitInsn(91);
                        if (selfEnumCall) {
                            this.mv.visitInsn(95);
                            this.mv.visitInsn(90);
                            this.mv.visitInsn(89);
                            this.mv.visitLdcInsn(0);
                            this.mv.visitInsn(50);
                            this.mv.visitInsn(95);
                            this.mv.visitLdcInsn(1);
                            this.mv.visitInsn(50);
                            Utils.insertUnboxInsns(this.mv, 'I', true);
                            this.mv.visitInsn(1);
                            this.mv.visitMethodInsn(183, owner, "<init>", "(Ljava/lang/String;ILorg/springsource/loaded/C;)V", itf);
                        } else if (owner.contains("_closure")) {
                            this.mv.visitInsn(95);
                            this.mv.visitInsn(90);
                            this.mv.visitInsn(89);
                            this.mv.visitLdcInsn(0);
                            this.mv.visitInsn(50);
                            this.mv.visitInsn(95);
                            this.mv.visitLdcInsn(1);
                            this.mv.visitInsn(50);
                            this.mv.visitInsn(1);
                            this.mv.visitMethodInsn(183, owner, "<init>", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/springsource/loaded/C;)V", itf);
                        } else {
                            this.mv.visitInsn(1);
                            this.mv.visitMethodInsn(183, owner, "<init>", "(Lorg/springsource/loaded/C;)V", itf);
                        }
                        this.mv.visitVarInsn(25, this.max + 1);
                        this.mv.visitInsn(91);
                        this.mv.visitInsn(87);
                        this.mv.visitInsn(95);
                        this.mv.visitLdcInsn(name + desc);
                    } else {
                        this.mv.visitInsn(89);
                        this.mv.visitInsn(1);
                        this.mv.visitMethodInsn(183, owner, "<init>", "(Lorg/springsource/loaded/C;)V", itf);
                        this.mv.visitVarInsn(25, this.max + 1);
                        this.mv.visitInsn(95);
                        this.mv.visitInsn(1);
                        this.mv.visitInsn(95);
                        this.mv.visitLdcInsn(name + desc);
                    }
                    this.mv.visitMethodInsn(185, "org/springsource/loaded/__DynamicallyDispatchable", "__execute", "([Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", true);
                    this.mv.visitInsn(87);
                    Label gotolabel = new Label();
                    this.mv.visitJumpInsn(167, gotolabel);
                    this.mv.visitLabel(l1);
                    this.mv.visitInsn(87);
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                    this.mv.visitLabel(gotolabel);
                } else {
                    this.mv.visitLdcInsn(Utils.toCombined(RewriteClassAdaptor.this.typeRegistry.getId(), classId));
                    this.mv.visitLdcInsn(name + desc);
                    this.mv.visitMethodInsn(184, "org/springsource/loaded/TypeRegistry", "ispcheck", "(ILjava/lang/String;)Lorg/springsource/loaded/__DynamicallyDispatchable;", false);
                    this.mv.visitInsn(89);
                    Label l1 = new Label();
                    this.mv.visitJumpInsn(198, l1);
                    this.mv.visitVarInsn(58, this.max + 1);
                    if (hasParams) {
                        Utils.collapseStackToArray(this.mv, desc);
                        this.mv.visitInsn(95);
                    }
                    this.mv.visitVarInsn(58, this.max + 2);
                    if (!hasParams) {
                        this.mv.visitVarInsn(25, this.max + 1);
                        this.mv.visitInsn(1);
                        this.mv.visitVarInsn(25, this.max + 2);
                    } else {
                        this.mv.visitVarInsn(25, this.max + 1);
                        this.mv.visitInsn(95);
                        this.mv.visitVarInsn(25, this.max + 2);
                    }
                    this.mv.visitLdcInsn(name + desc);
                    this.mv.visitMethodInsn(185, "org/springsource/loaded/__DynamicallyDispatchable", "__execute", "([Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", true);
                    this.insertAppropriateReturn(returnType);
                    Label gotolabel = new Label();
                    this.mv.visitJumpInsn(167, gotolabel);
                    this.mv.visitLabel(l1);
                    this.mv.visitInsn(87);
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                    this.mv.visitLabel(gotolabel);
                }
            }

            private void callReflectiveInterceptor(String owner, String name, String desc, MethodVisitor mv) {
                StringBuilder methodName = new StringBuilder();
                methodName.append(owner.charAt(0));
                int stop = owner.lastIndexOf("/");
                int index = owner.indexOf("/");
                while (index < stop) {
                    methodName.append(owner.charAt(index + 1));
                    index = owner.indexOf("/", index + 1);
                }
                methodName.append(owner, stop + 1, owner.length());
                methodName.append(Character.toUpperCase(name.charAt(0)));
                methodName.append(name, 1, name.length());
                StringBuilder newDescriptor = new StringBuilder("(L").append(owner).append(";").append(desc, 1, desc.length());
                mv.visitMethodInsn(184, "org/springsource/loaded/ri/ReflectiveInterceptor", methodName.toString(), newDescriptor.toString());
                RewriteClassAdaptor.this.rewroteReflection = true;
            }
        }
    }

    static class DontRewriteException
    extends RuntimeException {
        DontRewriteException() {
        }
    }
}

