/*
 * Decompiled with CFR 0.152.
 */
package org.grails.validation;

import grails.validation.AbstractVetoingConstraint;
import org.springframework.validation.Errors;

public class NullableConstraint
extends AbstractVetoingConstraint {
    private boolean nullable;

    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public boolean supports(Class type) {
        return type != null && !type.isPrimitive();
    }

    @Override
    public void setParameter(Object constraintParameter) {
        if (!(constraintParameter instanceof Boolean)) {
            throw new IllegalArgumentException("Parameter for constraint [nullable] of property [" + this.constraintPropertyName + "] of class [" + this.constraintOwningClass + "] must be a boolean value");
        }
        this.nullable = (Boolean)constraintParameter;
        super.setParameter(constraintParameter);
    }

    @Override
    public String getName() {
        return "nullable";
    }

    @Override
    protected boolean skipNullValues() {
        return false;
    }

    @Override
    protected boolean processValidateWithVetoing(Object target, Object propertyValue, Errors errors) {
        if (propertyValue == null && !this.nullable) {
            Object[] args = new Object[]{this.constraintPropertyName, this.constraintOwningClass};
            this.rejectValue(target, errors, "default.null.message", "nullable", args);
            return true;
        }
        return false;
    }
}

