/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.search;

import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.module.Module;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.roots.PackageIndex;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class PackageScope
extends GlobalSearchScope {
    private final Set<VirtualFile> myDirs;
    private final PsiPackage myPackage;
    private final boolean myIncludeSubpackages;
    private final boolean myIncludeLibraries;
    private final boolean myPartOfPackagePrefix;
    private final String myPackageQualifiedName;
    private final String myPackageQNamePrefix;

    public PackageScope(@NotNull PsiPackage aPackage, boolean includeSubpackages, boolean includeLibraries) {
        if (aPackage == null) {
            PackageScope.$$$reportNull$$$0(0);
        }
        super(aPackage.getProject());
        this.myPackage = aPackage;
        this.myIncludeSubpackages = includeSubpackages;
        Project project = this.myPackage.getProject();
        this.myPackageQualifiedName = this.myPackage.getQualifiedName();
        this.myDirs = ContainerUtil.newHashSet(PackageIndex.getInstance(project).getDirsByPackageName(this.myPackageQualifiedName, true).findAll());
        this.myIncludeLibraries = includeLibraries;
        this.myPartOfPackagePrefix = JavaPsiFacade.getInstance(this.getProject()).isPartOfPackagePrefix(this.myPackageQualifiedName);
        this.myPackageQNamePrefix = this.myPackageQualifiedName + ".";
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        String packageName;
        PsiFile psiFile;
        VirtualFile dir;
        if (file2 == null) {
            PackageScope.$$$reportNull$$$0(1);
        }
        VirtualFile virtualFile2 = dir = file2.isDirectory() ? file2 : file2.getParent();
        if (!this.myIncludeSubpackages) {
            if (this.myDirs.contains(dir)) {
                return true;
            }
        } else {
            while (dir != null) {
                if (this.myDirs.contains(dir)) {
                    return true;
                }
                dir = dir.getParent();
            }
        }
        return this.myPartOfPackagePrefix && this.myIncludeSubpackages && (psiFile = this.myPackage.getManager().findFile(file2)) instanceof PsiClassOwner && (this.myPackageQualifiedName.equals(packageName = ((PsiClassOwner)psiFile).getPackageName()) || packageName.startsWith(this.myPackageQNamePrefix));
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            PackageScope.$$$reportNull$$$0(2);
        }
        return true;
    }

    @Override
    public boolean isSearchInLibraries() {
        return this.myIncludeLibraries;
    }

    public String toString() {
        return "package scope: " + this.myPackage + ", includeSubpackages = " + this.myIncludeSubpackages;
    }

    @NotNull
    public static GlobalSearchScope packageScope(@NotNull PsiPackage aPackage, boolean includeSubpackages) {
        if (aPackage == null) {
            PackageScope.$$$reportNull$$$0(3);
        }
        PackageScope packageScope = new PackageScope(aPackage, includeSubpackages, true);
        if (packageScope == null) {
            PackageScope.$$$reportNull$$$0(4);
        }
        return packageScope;
    }

    @NotNull
    public static GlobalSearchScope packageScopeWithoutLibraries(@NotNull PsiPackage aPackage, boolean includeSubpackages) {
        if (aPackage == null) {
            PackageScope.$$$reportNull$$$0(5);
        }
        PackageScope packageScope = new PackageScope(aPackage, includeSubpackages, false);
        if (packageScope == null) {
            PackageScope.$$$reportNull$$$0(6);
        }
        return packageScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModule";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/search/PackageScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/search/PackageScope";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "packageScope";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "packageScopeWithoutLibraries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "packageScope";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "packageScopeWithoutLibraries";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

