/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts;

import com.google.common.base.Objects;
import java.math.BigInteger;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheLockingManager;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.AbstractArtifactsCache;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.ArtifactsAtRepositoryKey;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentIdentifierSerializer;
import org.gradle.api.internal.artifacts.metadata.ComponentArtifactMetadataSerializer;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SetSerializer;
import org.gradle.util.BuildCommencedTimeProvider;

public class DefaultModuleArtifactsCache
extends AbstractArtifactsCache {
    private final ArtifactCacheLockingManager artifactCacheLockingManager;
    private PersistentIndexedCache<ArtifactsAtRepositoryKey, AbstractArtifactsCache.ModuleArtifactsCacheEntry> cache;

    public DefaultModuleArtifactsCache(BuildCommencedTimeProvider timeProvider, ArtifactCacheLockingManager artifactCacheLockingManager) {
        super(timeProvider);
        this.artifactCacheLockingManager = artifactCacheLockingManager;
    }

    private PersistentIndexedCache<ArtifactsAtRepositoryKey, AbstractArtifactsCache.ModuleArtifactsCacheEntry> getCache() {
        if (this.cache == null) {
            this.cache = this.initCache();
        }
        return this.cache;
    }

    private PersistentIndexedCache<ArtifactsAtRepositoryKey, AbstractArtifactsCache.ModuleArtifactsCacheEntry> initCache() {
        return this.artifactCacheLockingManager.createCache("module-artifacts", new ModuleArtifactsKeySerializer(), new ModuleArtifactsCacheEntrySerializer());
    }

    @Override
    protected void store(ArtifactsAtRepositoryKey key, AbstractArtifactsCache.ModuleArtifactsCacheEntry entry) {
        this.getCache().put((Object)key, (Object)entry);
    }

    @Override
    protected AbstractArtifactsCache.ModuleArtifactsCacheEntry get(ArtifactsAtRepositoryKey key) {
        return (AbstractArtifactsCache.ModuleArtifactsCacheEntry)this.getCache().get((Object)key);
    }

    private static class ModuleArtifactsCacheEntrySerializer
    extends AbstractSerializer<AbstractArtifactsCache.ModuleArtifactsCacheEntry> {
        private final Serializer<Set<ComponentArtifactMetadata>> artifactsSerializer = new SetSerializer((Serializer)new ComponentArtifactMetadataSerializer());

        private ModuleArtifactsCacheEntrySerializer() {
        }

        public void write(Encoder encoder, AbstractArtifactsCache.ModuleArtifactsCacheEntry value) throws Exception {
            encoder.writeLong(value.createTimestamp);
            byte[] hash = value.moduleDescriptorHash.toByteArray();
            encoder.writeBinary(hash);
            this.artifactsSerializer.write(encoder, value.artifacts);
        }

        public AbstractArtifactsCache.ModuleArtifactsCacheEntry read(Decoder decoder) throws Exception {
            long createTimestamp = decoder.readLong();
            byte[] encodedHash = decoder.readBinary();
            BigInteger hash = new BigInteger(encodedHash);
            Set artifacts = (Set)this.artifactsSerializer.read(decoder);
            return new AbstractArtifactsCache.ModuleArtifactsCacheEntry(artifacts, createTimestamp, hash);
        }

        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            ModuleArtifactsCacheEntrySerializer rhs = (ModuleArtifactsCacheEntrySerializer)((Object)obj);
            return Objects.equal(this.artifactsSerializer, rhs.artifactsSerializer);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.artifactsSerializer});
        }
    }

    private static class ModuleArtifactsKeySerializer
    extends AbstractSerializer<ArtifactsAtRepositoryKey> {
        private final ComponentIdentifierSerializer identifierSerializer = new ComponentIdentifierSerializer();

        private ModuleArtifactsKeySerializer() {
        }

        public void write(Encoder encoder, ArtifactsAtRepositoryKey value) throws Exception {
            encoder.writeString((CharSequence)value.repositoryId);
            this.identifierSerializer.write(encoder, value.componentId);
            encoder.writeString((CharSequence)value.context);
        }

        public ArtifactsAtRepositoryKey read(Decoder decoder) throws Exception {
            String resolverId = decoder.readString();
            ComponentIdentifier componentId = this.identifierSerializer.read(decoder);
            String context = decoder.readString();
            return new ArtifactsAtRepositoryKey(resolverId, componentId, context);
        }

        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            ModuleArtifactsKeySerializer rhs = (ModuleArtifactsKeySerializer)((Object)obj);
            return Objects.equal((Object)((Object)this.identifierSerializer), (Object)((Object)rhs.identifierSerializer));
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.identifierSerializer});
        }
    }
}

