/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.PeCoffGroupMsSymbol;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.SymbolGroup;
import ghidra.program.model.address.Address;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;

public class PeCoffGroupSymbolApplier
extends MsSymbolApplier {
    private PeCoffGroupMsSymbol symbol;

    public PeCoffGroupSymbolApplier(PdbApplicator applicator, SymbolGroup.AbstractMsSymbolIterator iter) {
        super(applicator, iter);
        AbstractMsSymbol abstractSymbol = iter.next();
        if (!(abstractSymbol instanceof PeCoffGroupMsSymbol)) {
            throw new AssertException("Invalid symbol type: " + abstractSymbol.getClass().getSimpleName());
        }
        this.symbol = (PeCoffGroupMsSymbol)abstractSymbol;
    }

    @Override
    void apply() throws PdbException, CancelledException {
        this.applicator.addMemoryGroupRefinement(this.symbol);
        Address symbolAddress = this.applicator.getAddress(this.symbol);
        if (this.applicator.isInvalidAddress(symbolAddress, this.symbol.getName())) {
            return;
        }
        this.applicator.createSymbol(symbolAddress, this.symbol.getName(), false);
    }

    @Override
    void applyTo(MsSymbolApplier applyToApplier) {
    }
}

