/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import java.util.HashMap;
import java.util.Map;

public class PdbRegisterNameToProgramRegisterMapper {
    private static final Map<String, String> REGISTER_NAME_MAP = Map.of("fbp", "RBP");
    private Program program;
    private Map<String, Register> pdbRegisterNameToRegisterMap;

    public PdbRegisterNameToProgramRegisterMapper(Program program) {
        this.program = program;
        this.pdbRegisterNameToRegisterMap = new HashMap<String, Register>();
    }

    Register getRegister(String pdbRegisterName) {
        Register register = this.pdbRegisterNameToRegisterMap.get(pdbRegisterName);
        if (register != null) {
            return register;
        }
        String registerName = REGISTER_NAME_MAP.get(pdbRegisterName);
        if (registerName == null) {
            registerName = pdbRegisterName;
        }
        register = this.program.getRegister(registerName);
        this.pdbRegisterNameToRegisterMap.put(pdbRegisterName, register);
        if (register == null) {
            Msg.info((Object)this, (Object)("Program register not found for " + registerName));
        }
        return register;
    }
}

