/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractComplexMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MsProperty;

public abstract class AbstractEnumMsType
extends AbstractComplexMsType {
    private static final String TYPE_STRING = "enum";
    protected RecordNumber underlyingRecordNumber;

    public AbstractEnumMsType(AbstractPdb pdb, PdbByteReader reader) {
        super(pdb, reader);
    }

    public AbstractEnumMsType(AbstractPdb pdb, String name, RecordNumber underlyingRecordNumber, RecordNumber fieldDescriptorRecordNumber, MsProperty property, int numElements) {
        super(pdb, null);
        this.name = name;
        this.underlyingRecordNumber = underlyingRecordNumber;
        this.fieldDescriptorListRecordNumber = fieldDescriptorRecordNumber;
        this.property = property;
        this.count = numElements;
    }

    public RecordNumber getUnderlyingRecordNumber() {
        return this.underlyingRecordNumber;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        StringBuilder myBuilder = new StringBuilder();
        myBuilder.append(this.getTypeString());
        myBuilder.append(" ");
        myBuilder.append(this.name);
        myBuilder.append("<");
        if (this.count != -1) {
            myBuilder.append(this.count);
            myBuilder.append(",");
        }
        myBuilder.append(this.pdb.getTypeRecord(this.underlyingRecordNumber));
        myBuilder.append(",");
        myBuilder.append(this.property);
        myBuilder.append(">");
        if (this.fieldDescriptorListRecordNumber != RecordNumber.NO_TYPE) {
            myBuilder.append(this.pdb.getTypeRecord(this.fieldDescriptorListRecordNumber));
        }
        myBuilder.append(" ");
        builder.insert(0, myBuilder);
    }

    @Override
    protected String getTypeString() {
        return TYPE_STRING;
    }
}

