/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;

public class CvReservedMsSymbol
extends AbstractMsSymbol {
    public static final int PDB_ID = 8;
    private int recordLength;

    public CvReservedMsSymbol(AbstractPdb pdb, PdbByteReader reader) {
        super(pdb, reader);
        this.recordLength = reader.getLimit() - reader.getIndex();
    }

    @Override
    public int getPdbId() {
        return 8;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("%s, Length = 0x%X", this.getSymbolTypeName(), this.recordLength));
    }

    @Override
    protected String getSymbolTypeName() {
        return "CVRESERVE";
    }
}

