/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;

public class DebugHeader {
    private long headerVersion;
    private long headerLength;
    private long dataLength;

    public long getHeaderVersion() {
        return this.headerVersion;
    }

    public long getHeaderLength() {
        return this.headerLength;
    }

    public long getDataLength() {
        return this.dataLength;
    }

    public void deserialize(PdbByteReader reader) throws PdbException {
        this.headerVersion = reader.parseUnsignedIntVal();
        this.headerLength = reader.parseUnsignedIntVal();
        this.dataLength = reader.parseUnsignedIntVal();
    }

    public String toString() {
        return this.dump();
    }

    String dump() {
        StringBuilder builder = new StringBuilder();
        builder.append("DebugHeader-------------------------------------------------\n");
        this.dumpInternal(builder);
        builder.append("End DebugHeader---------------------------------------------\n");
        return builder.toString();
    }

    protected void dumpInternal(StringBuilder builder) {
        builder.append(String.format("headerVersion: 0X%08X\n", this.headerVersion));
        builder.append(String.format("headerLength: 0X%08X\n", this.headerLength));
        builder.append(String.format("dataLength: 0X%08X\n", this.dataLength));
    }
}

