/*
 * Decompiled with CFR 0.152.
 */
package org.prevayler.implementation.publishing;

import java.io.IOException;
import org.prevayler.Clock;
import org.prevayler.foundation.Cool;
import org.prevayler.foundation.Turn;
import org.prevayler.implementation.Capsule;
import org.prevayler.implementation.TransactionGuide;
import org.prevayler.implementation.TransactionTimestamp;
import org.prevayler.implementation.clock.PausableClock;
import org.prevayler.implementation.journal.Journal;
import org.prevayler.implementation.publishing.AbstractPublisher;
import org.prevayler.implementation.publishing.TransactionSubscriber;

public class CentralPublisher
extends AbstractPublisher {
    private final PausableClock _pausableClock;
    private final Journal _journal;
    private volatile int _pendingPublications = 0;
    private final Object _pendingPublicationsMonitor = new Object();
    private Turn _nextTurn = Turn.first();
    private long _nextTransaction;
    private final Object _nextTurnMonitor = new Object();

    public CentralPublisher(Clock clock, Journal journal) {
        super(new PausableClock(clock));
        this._pausableClock = (PausableClock)this._clock;
        this._journal = journal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(Capsule capsule) {
        Object object = this._pendingPublicationsMonitor;
        synchronized (object) {
            if (this._pendingPublications == 0) {
                this._pausableClock.pause();
            }
            ++this._pendingPublications;
        }
        try {
            this.publishWithoutWorryingAboutNewSubscriptions(capsule);
        }
        finally {
            object = this._pendingPublicationsMonitor;
            synchronized (object) {
                --this._pendingPublications;
                if (this._pendingPublications == 0) {
                    this._pausableClock.resume();
                    this._pendingPublicationsMonitor.notifyAll();
                }
            }
        }
    }

    private void publishWithoutWorryingAboutNewSubscriptions(Capsule capsule) {
        TransactionGuide guide = this.guideFor(capsule);
        this._journal.append(guide);
        this.notifySubscribers(guide);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionGuide guideFor(Capsule capsule) {
        Object object = this._nextTurnMonitor;
        synchronized (object) {
            TransactionTimestamp timestamp = new TransactionTimestamp(capsule, this._nextTransaction, this._pausableClock.realTime());
            Turn turn = this._nextTurn;
            this._nextTurn = this._nextTurn.next();
            ++this._nextTransaction;
            return new TransactionGuide(timestamp, turn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySubscribers(TransactionGuide guide) {
        guide.startTurn();
        try {
            this._pausableClock.advanceTo(guide.executionTime());
            this.notifySubscribers(guide.timestamp());
        }
        finally {
            guide.endTurn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(TransactionSubscriber subscriber, long initialTransaction) throws IOException, ClassNotFoundException {
        Object object = this._pendingPublicationsMonitor;
        synchronized (object) {
            while (this._pendingPublications != 0) {
                Cool.wait(this._pendingPublicationsMonitor);
            }
            this._journal.update(subscriber, initialTransaction);
            Object object2 = this._nextTurnMonitor;
            synchronized (object2) {
                this._nextTransaction = this._journal.nextTransaction();
            }
            super.addSubscriber(subscriber);
        }
    }

    @Override
    public void close() throws IOException {
        this._journal.close();
    }
}

