/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.nio.ByteBuffer;

public class DbgReadBusDataCommand
extends AbstractDbgCommand<RangeSet<Long>> {
    private final long addr;
    private final ByteBuffer buf;
    private final int len;
    private final int busDataType;
    private final int busNumber;
    private final int slotNumber;
    private int readLen;

    public DbgReadBusDataCommand(DbgManagerImpl manager, long addr, ByteBuffer buf, int len, int busDataType, int busNumber, int slotNumber) {
        super(manager);
        this.addr = addr;
        this.buf = buf;
        this.len = len;
        this.busDataType = busDataType;
        this.busNumber = busNumber;
        this.slotNumber = slotNumber;
    }

    @Override
    public RangeSet<Long> complete(DbgPendingCommand<?> pending) {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closedOpen((Comparable)Long.valueOf(this.addr), (Comparable)Long.valueOf(this.addr + (long)this.readLen)));
        return rangeSet;
    }

    @Override
    public void invoke() {
        this.readLen = this.manager.getDataSpaces().readBusData(this.busDataType, this.busNumber, this.slotNumber, this.addr, this.buf, this.len);
    }
}

