/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.impl.dbgeng;

import agent.dbgeng.dbgeng.DebugRunningProcess;
import agent.dbgeng.dbgeng.DebugServerId;
import agent.dbgeng.impl.dbgeng.client.DebugClientInternal;
import ghidra.comm.util.BitmaskSet;

public class DebugRunningProcessImpl
implements DebugRunningProcess,
Comparable<DebugRunningProcessImpl> {
    protected final DebugClientInternal client;
    protected final DebugServerId server;
    protected final int systemId;

    public DebugRunningProcessImpl(DebugClientInternal client, DebugServerId server, int systemId) {
        this.client = client;
        this.server = server;
        this.systemId = systemId;
    }

    @Override
    public int getSystemId() {
        return this.systemId;
    }

    @Override
    public DebugRunningProcess.Description getFullDescription(DebugRunningProcess.Description.ProcessDescriptionFlags ... flags) {
        return this.client.getProcessDescription(this.server, this.systemId, (BitmaskSet<DebugRunningProcess.Description.ProcessDescriptionFlags>)BitmaskSet.of((Enum[])flags));
    }

    @Override
    public String getExecutableName(DebugRunningProcess.Description.ProcessDescriptionFlags ... flags) {
        return this.getFullDescription(flags).getExecutableName();
    }

    @Override
    public String getDescription(DebugRunningProcess.Description.ProcessDescriptionFlags ... flags) {
        return this.getFullDescription(flags).getDescription();
    }

    @Override
    public int compareTo(DebugRunningProcessImpl that) {
        int result = Integer.compare(this.systemId, that.systemId);
        if (result != 0) {
            return result;
        }
        return 0;
    }
}

