/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.pcode.emu.DefaultPcodeThread;
import ghidra.pcode.emu.PcodeMachine;
import ghidra.pcode.emu.PcodeStateInitializer;
import ghidra.pcode.emu.PcodeThread;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeProgram;
import ghidra.pcode.exec.SleighProgramCompiler;
import ghidra.pcode.exec.SleighUseropLibrary;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Language;
import ghidra.util.classfinder.ClassSearcher;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractPcodeMachine<T>
implements PcodeMachine<T> {
    protected final SleighLanguage language;
    protected final PcodeArithmetic<T> arithmetic;
    protected final SleighUseropLibrary<T> library;
    protected final SleighUseropLibrary<T> stubLibrary;
    PcodeStateInitializer initializer;
    private PcodeExecutorState<T> sharedState;
    protected final Map<String, PcodeThread<T>> threads = new LinkedHashMap<String, PcodeThread<T>>();
    protected final Collection<PcodeThread<T>> threadsView = Collections.unmodifiableCollection(this.threads.values());
    protected final Map<Address, PcodeProgram> injects = new HashMap<Address, PcodeProgram>();

    public AbstractPcodeMachine(SleighLanguage language, PcodeArithmetic<T> arithmetic, SleighUseropLibrary<T> library) {
        this.language = language;
        this.arithmetic = arithmetic;
        this.library = library;
        this.stubLibrary = this.createThreadStubLibrary().compose(library);
        this.initializer = AbstractPcodeMachine.getPluggableInitializer((Language)language);
    }

    @Override
    public SleighLanguage getLanguage() {
        return this.language;
    }

    @Override
    public PcodeArithmetic<T> getArithmetic() {
        return this.arithmetic;
    }

    @Override
    public SleighUseropLibrary<T> getUseropLibrary() {
        return this.library;
    }

    @Override
    public SleighUseropLibrary<T> getStubUseropLibrary() {
        return this.stubLibrary;
    }

    protected abstract PcodeExecutorState<T> createSharedState();

    protected abstract PcodeExecutorState<T> createLocalState(PcodeThread<T> var1);

    protected SleighUseropLibrary<T> createThreadStubLibrary() {
        return new DefaultPcodeThread.SleighEmulationLibrary(null);
    }

    protected PcodeThread<T> createThread(String name) {
        return new DefaultPcodeThread(name, this);
    }

    protected static PcodeStateInitializer getPluggableInitializer(Language language) {
        for (PcodeStateInitializer init : ClassSearcher.getInstances(PcodeStateInitializer.class)) {
            if (!init.isApplicable(language)) continue;
            return init;
        }
        return null;
    }

    protected void doPluggableInitialization() {
        if (this.initializer != null) {
            this.initializer.initializeMachine(this);
        }
    }

    @Override
    public PcodeThread<T> newThread() {
        return this.newThread("Thread " + this.threads.size());
    }

    @Override
    public PcodeThread<T> newThread(String name) {
        if (this.threads.containsKey(name)) {
            throw new IllegalStateException("Thread with name '" + name + "' already exists");
        }
        PcodeThread<T> thread = this.createThread(name);
        this.threads.put(name, thread);
        return thread;
    }

    @Override
    public PcodeThread<T> getThread(String name, boolean createIfAbsent) {
        PcodeThread<T> thread = this.threads.get(name);
        if (thread == null && createIfAbsent) {
            thread = this.newThread(name);
        }
        return thread;
    }

    @Override
    public Collection<? extends PcodeThread<T>> getAllThreads() {
        return this.threadsView;
    }

    @Override
    public PcodeExecutorState<T> getSharedState() {
        if (this.sharedState == null) {
            this.sharedState = this.createSharedState();
            this.doPluggableInitialization();
        }
        return this.sharedState;
    }

    protected PcodeProgram getInject(Address address) {
        return this.injects.get(address);
    }

    @Override
    public PcodeProgram compileSleigh(String sourceName, List<String> lines) {
        return SleighProgramCompiler.compileProgram(this.language, sourceName, lines, this.stubLibrary);
    }

    @Override
    public void inject(Address address, List<String> sleigh) {
        PcodeProgram pcode = this.compileSleigh("machine_inject:" + address, sleigh);
        this.injects.put(address, pcode);
    }

    @Override
    public void clearInject(Address address) {
        this.injects.remove(address);
    }

    @Override
    public void clearAllInjects() {
        this.injects.clear();
    }

    @Override
    public void addBreakpoint(Address address, String sleighCondition) {
        PcodeProgram pcode = this.compileSleigh("breakpoint:" + address, List.of("if (!(" + sleighCondition + ")) goto <nobreak>;", "    emu_swi();", "<nobreak>", "    emu_exec_decoded();"));
        this.injects.put(address, pcode);
    }
}

