/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.png;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.ios.png.CrushedPNGConstants;
import ghidra.file.formats.ios.png.IHDRChunk;
import ghidra.file.formats.ios.png.PNGChunk;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ProcessedPNG
implements StructConverter {
    private byte[] fileSignature;
    private List<PNGChunk> chunks;
    private int totalLength;
    private IHDRChunk ihdrChunk;

    public ProcessedPNG(BinaryReader reader, TaskMonitor monitor) throws IOException {
        if (reader != null) {
            this.chunks = new ArrayList<PNGChunk>();
            this.fileSignature = reader.readNextByteArray(CrushedPNGConstants.SIGNATURE_BYTES.length);
            this.totalLength += this.fileSignature.length;
            while (!monitor.isCancelled()) {
                PNGChunk chunk = new PNGChunk(reader);
                if (chunk.getIDString().equals("IEND")) {
                    this.chunks.add(chunk);
                    this.totalLength += chunk.getTotalLength();
                    break;
                }
                if (chunk.getIDString().equals("IHDR")) {
                    this.totalLength += chunk.getTotalLength();
                    this.ihdrChunk = new IHDRChunk(chunk);
                    this.chunks.add(chunk);
                    continue;
                }
                this.totalLength += chunk.getTotalLength();
                this.chunks.add(chunk);
            }
        } else {
            throw new IOException("Reader is null");
        }
    }

    public IHDRChunk getIHDRChunk() {
        return this.ihdrChunk;
    }

    public int getTotalLength() {
        return this.totalLength;
    }

    public byte[] getFileSignature() {
        return this.fileSignature;
    }

    public List<PNGChunk> getChunkArray() {
        return this.chunks;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struc = new StructureDataType("CrushedPNG", 0);
        struc.add((DataType)new ArrayDataType(BYTE, this.fileSignature.length, 1), "File Signature", new String(this.fileSignature));
        for (PNGChunk chunk : this.chunks) {
            struc.add(chunk.toDataType());
        }
        return struc;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("Type: Crushed PNG Image\n");
        buff.append("Size: " + this.totalLength + " bytes\n");
        buff.append("PNG Chunks: \n");
        for (PNGChunk chunk : this.chunks) {
            buff.append("    " + chunk.getIDString() + "\n");
        }
        return buff.toString();
    }
}

