/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model;

import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceSnap;
import java.util.Objects;

public class DefaultTraceSnap
implements TraceSnap {
    private final Trace trace;
    private final long snap;

    public DefaultTraceSnap(Trace trace, long snap) {
        this.trace = trace;
        this.snap = snap;
    }

    @Override
    public Trace getTrace() {
        return this.trace;
    }

    @Override
    public long getSnap() {
        return this.snap;
    }

    public String toString() {
        return "TraceSnap<" + this.trace + ": " + this.snap + ">";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultTraceSnap)) {
            return false;
        }
        DefaultTraceSnap that = (DefaultTraceSnap)obj;
        if (this.trace != that.trace) {
            return false;
        }
        return this.snap == that.snap;
    }

    public int hashCode() {
        return Objects.hash(this.trace, this.snap);
    }

    @Override
    public int compareTo(TraceSnap that) {
        if (this == that) {
            return 0;
        }
        int result = this.trace.getName().compareTo(that.getTrace().getName());
        if (result != 0) {
            return result;
        }
        result = Long.compareUnsigned(this.snap, that.getSnap());
        if (result != 0) {
            return result;
        }
        return 0;
    }
}

