/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.map;

import com.google.common.collect.Range;
import generic.util.PeekableIterator;
import ghidra.program.model.address.Address;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapSpace;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.model.ImmutableTraceAddressSnapRange;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.util.database.spatial.rect.Rectangle2DDirection;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.tuple.ImmutablePair;

public abstract class AbstractDBTraceAddressSnapRangePropertyMapOcclusionIterable<T>
implements Iterable<Map.Entry<TraceAddressSnapRange, T>> {
    protected final DBTraceAddressSnapRangePropertyMapSpace<T, ?> space;
    protected final TraceAddressSnapRange within;

    public AbstractDBTraceAddressSnapRangePropertyMapOcclusionIterable(DBTraceAddressSnapRangePropertyMapSpace<T, ?> space, TraceAddressSnapRange within) {
        this.space = space;
        this.within = within;
    }

    protected abstract Rectangle2DDirection getVerticalDirection();

    protected abstract Range<Long> getOcclusionRange(Range<Long> var1);

    @Override
    public PeekableIterator<Map.Entry<TraceAddressSnapRange, T>> iterator() {
        return new PeekableIterator<Map.Entry<TraceAddressSnapRange, T>>(){
            protected Address address;
            protected boolean soughtNext;
            protected Map.Entry<TraceAddressSnapRange, T> next;
            {
                this.address = AbstractDBTraceAddressSnapRangePropertyMapOcclusionIterable.this.within.getX1();
                this.soughtNext = false;
                this.next = null;
            }

            private void checkSeekNext() {
                if (this.soughtNext) {
                    return;
                }
                this.soughtNext = true;
                this.next = this.seekNext();
            }

            private Map.Entry<TraceAddressSnapRange, T> seekNext() {
                if (this.address == null || !AbstractDBTraceAddressSnapRangePropertyMapOcclusionIterable.this.within.getRange().contains(this.address)) {
                    return null;
                }
                Map.Entry topAtAddress = AbstractDBTraceAddressSnapRangePropertyMapOcclusionIterable.this.space.reduce((DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery)DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(this.address, this.address, AbstractDBTraceAddressSnapRangePropertyMapOcclusionIterable.this.within.getY1(), AbstractDBTraceAddressSnapRangePropertyMapOcclusionIterable.this.within.getY2()).starting(AbstractDBTraceAddressSnapRangePropertyMapOcclusionIterable.this.getVerticalDirection())).firstEntry();
                if (topAtAddress == null) {
                    Map.Entry nextEntry = AbstractDBTraceAddressSnapRangePropertyMapOcclusionIterable.this.space.reduce((DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery)DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(this.address, AbstractDBTraceAddressSnapRangePropertyMapOcclusionIterable.this.within.getX2(), AbstractDBTraceAddressSnapRangePropertyMapOcclusionIterable.this.within.getY1(), AbstractDBTraceAddressSnapRangePropertyMapOcclusionIterable.this.within.getY2()).starting(Rectangle2DDirection.LEFTMOST)).firstEntry();
                    if (nextEntry == null) {
                        return null;
                    }
                    this.address = ((TraceAddressSnapRange)nextEntry.getKey()).getX1();
                    topAtAddress = AbstractDBTraceAddressSnapRangePropertyMapOcclusionIterable.this.space.reduce((DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery)DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(this.address, this.address, AbstractDBTraceAddressSnapRangePropertyMapOcclusionIterable.this.within.getY1(), AbstractDBTraceAddressSnapRangePropertyMapOcclusionIterable.this.within.getY2()).starting(AbstractDBTraceAddressSnapRangePropertyMapOcclusionIterable.this.getVerticalDirection())).firstEntry();
                }
                Map.Entry occludes = null;
                Range<Long> occlusionRange = AbstractDBTraceAddressSnapRangePropertyMapOcclusionIterable.this.getOcclusionRange(((TraceAddressSnapRange)topAtAddress.getKey()).getLifespan());
                if (occlusionRange != null) {
                    occludes = AbstractDBTraceAddressSnapRangePropertyMapOcclusionIterable.this.space.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(this.address, AbstractDBTraceAddressSnapRangePropertyMapOcclusionIterable.this.within.getX2(), AbstractDBTraceAddressSnapRangePropertyMapOcclusionIterable.this.within.getY1(), AbstractDBTraceAddressSnapRangePropertyMapOcclusionIterable.this.within.getY2())).reduce((Object)((DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery)DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(((TraceAddressSnapRange)topAtAddress.getKey()).getRange(), occlusionRange).starting(Rectangle2DDirection.LEFTMOST))).firstEntry();
                }
                if (occludes == null) {
                    ImmutablePair result = new ImmutablePair((Object)((TraceAddressSnapRange)new ImmutableTraceAddressSnapRange(this.address, ((TraceAddressSnapRange)topAtAddress.getKey()).getX2(), ((TraceAddressSnapRange)topAtAddress.getKey()).getY1(), ((TraceAddressSnapRange)topAtAddress.getKey()).getY2()).intersection(AbstractDBTraceAddressSnapRangePropertyMapOcclusionIterable.this.within)), topAtAddress.getValue());
                    this.address = ((TraceAddressSnapRange)topAtAddress.getKey()).getX2().next();
                    return result;
                }
                ImmutablePair result = new ImmutablePair((Object)((TraceAddressSnapRange)new ImmutableTraceAddressSnapRange(this.address, ((TraceAddressSnapRange)occludes.getKey()).getX1().previous(), ((TraceAddressSnapRange)topAtAddress.getKey()).getY1(), ((TraceAddressSnapRange)topAtAddress.getKey()).getY2()).intersection(AbstractDBTraceAddressSnapRangePropertyMapOcclusionIterable.this.within)), topAtAddress.getValue());
                this.address = ((TraceAddressSnapRange)occludes.getKey()).getX1();
                return result;
            }

            public boolean hasNext() {
                this.checkSeekNext();
                return this.next != null;
            }

            public Map.Entry<TraceAddressSnapRange, T> peek() throws NoSuchElementException {
                this.checkSeekNext();
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                return this.next;
            }

            public Map.Entry<TraceAddressSnapRange, T> next() {
                this.checkSeekNext();
                this.soughtNext = false;
                return this.next;
            }
        };
    }
}

