/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec.trace;

import ghidra.generic.util.datastruct.SemisparseByteArray;
import ghidra.pcode.exec.AbstractLongOffsetPcodeExecutorState;
import ghidra.pcode.exec.BytesPcodeArithmetic;
import ghidra.pcode.exec.PairedPcodeExecutorState;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.trace.TraceMemoryStatePcodeExecutorStatePiece;
import ghidra.pcode.exec.trace.TraceSleighUtils;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.mem.MemBuffer;
import ghidra.trace.model.Trace;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.DefaultTraceTimeViewport;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class TraceBytesPcodeExecutorState
extends AbstractLongOffsetPcodeExecutorState<byte[], TraceMemorySpace> {
    protected final SemisparseByteArray unique = new SemisparseByteArray();
    private final Trace trace;
    private long snap;
    private TraceThread thread;
    private int frame;
    private final DefaultTraceTimeViewport viewport;

    public TraceBytesPcodeExecutorState(Trace trace, long snap, TraceThread thread, int frame) {
        super(trace.getBaseLanguage(), (PcodeArithmetic)BytesPcodeArithmetic.forLanguage((Language)trace.getBaseLanguage()));
        this.trace = trace;
        this.snap = snap;
        this.thread = thread;
        this.frame = frame;
        this.viewport = new DefaultTraceTimeViewport(trace);
        this.viewport.setSnap(snap);
    }

    public PcodeExecutorState<Pair<byte[], TraceMemoryState>> withMemoryState() {
        return new PairedPcodeExecutorState<byte[], TraceMemoryState>((PcodeExecutorStatePiece)this, (PcodeExecutorStatePiece)new TraceMemoryStatePcodeExecutorStatePiece(this.trace, this.snap, this.thread, this.frame)){

            public void setVar(AddressSpace space, Pair<byte[], TraceMemoryState> offset, int size, boolean truncateAddressableUnit, Pair<byte[], TraceMemoryState> val) {
                if (offset.getRight() == TraceMemoryState.KNOWN) {
                    super.setVar(space, offset, size, truncateAddressableUnit, val);
                    return;
                }
                super.setVar(space, offset, size, truncateAddressableUnit, (Object)new ImmutablePair((Object)((byte[])val.getLeft()), (Object)TraceMemoryState.UNKNOWN));
            }

            public Pair<byte[], TraceMemoryState> getVar(AddressSpace space, Pair<byte[], TraceMemoryState> offset, int size, boolean truncateAddressableUnit) {
                Pair result = (Pair)super.getVar(space, offset, size, truncateAddressableUnit);
                if (offset.getRight() == TraceMemoryState.KNOWN) {
                    return result;
                }
                return new ImmutablePair((Object)((byte[])result.getLeft()), (Object)TraceMemoryState.UNKNOWN);
            }
        };
    }

    public Trace getTrace() {
        return this.trace;
    }

    public void setSnap(long snap) {
        this.snap = snap;
        this.viewport.setSnap(snap);
    }

    public long getSnap() {
        return this.snap;
    }

    public void setThread(TraceThread thread) {
        if (thread != null & thread.getTrace() != this.trace) {
            throw new IllegalArgumentException("Thread, if given, must be part of the same trace");
        }
        this.thread = thread;
    }

    public TraceThread getThread() {
        return this.thread;
    }

    public void setFrame(int frame) {
        this.frame = frame;
    }

    public int getFrame() {
        return this.frame;
    }

    public long offsetToLong(byte[] offset) {
        return Utils.bytesToLong((byte[])offset, (int)offset.length, (boolean)this.language.isBigEndian());
    }

    public byte[] longToOffset(AddressSpace space, long l) {
        return (byte[])this.arithmetic.fromConst(l, space.getPointerSize());
    }

    protected void setUnique(long offset, int size, byte[] val) {
        assert (size == val.length);
        this.unique.putData(offset, val);
    }

    protected byte[] getUnique(long offset, int size) {
        byte[] data = new byte[size];
        this.unique.getData(offset, data);
        return data;
    }

    protected TraceMemorySpace getForSpace(AddressSpace space, boolean toWrite) {
        return TraceSleighUtils.getSpaceForExecution(space, this.trace, this.thread, this.frame, toWrite);
    }

    protected void setInSpace(TraceMemorySpace space, long offset, int size, byte[] val) {
        assert (size == val.length);
        int wrote = space.putBytes(this.snap, space.getAddressSpace().getAddress(offset), ByteBuffer.wrap(val));
        if (wrote != size) {
            throw new RuntimeException("Could not write full value to trace");
        }
    }

    protected byte[] getFromSpace(TraceMemorySpace space, long offset, int size) {
        ByteBuffer buf = ByteBuffer.allocate(size);
        int read = space.getViewBytes(this.snap, space.getAddressSpace().getAddress(offset), buf);
        if (read != size) {
            throw new RuntimeException("Could not read full value from trace");
        }
        return buf.array();
    }

    public MemBuffer getConcreteBuffer(Address address) {
        return this.trace.getMemoryManager().getBufferAt(this.snap, address);
    }
}

