/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.workflow;

import com.google.common.collect.Range;
import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.plugin.core.debug.service.workflow.AbstractMultiToolTraceListener;
import ghidra.app.plugin.core.debug.service.workflow.DebuggerWorkflowServicePlugin;
import ghidra.app.plugin.core.debug.service.workflow.MultiToolTraceListenerManager;
import ghidra.app.plugin.core.debug.workflow.DisassemblyInject;
import ghidra.app.services.DebuggerBot;
import ghidra.app.services.DebuggerBotInfo;
import ghidra.async.AsyncDebouncer;
import ghidra.async.AsyncTimer;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.options.annotation.HelpInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.lang.Register;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.listing.TraceCodeManager;
import ghidra.trace.model.listing.TraceCodeRegisterSpace;
import ghidra.trace.model.listing.TraceData;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.stack.TraceStackManager;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceAddressSpace;
import ghidra.trace.util.TraceChangeType;
import ghidra.trace.util.TraceRegisterUtils;
import ghidra.trace.util.TraceTimeViewport;
import ghidra.trace.util.TraceViewportSpanIterator;
import ghidra.util.IntersectionAddressSetView;
import ghidra.util.Msg;
import ghidra.util.UnionAddressSetView;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.database.UndoableTransaction;
import ghidra.util.task.TaskMonitor;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeListener;

@DebuggerBotInfo(description="Disassemble memory at the program counter", details="Listens for changes in memory or pc (stack or registers) and disassembles", help=@HelpInfo(anchor="disassemble_at_pc"), enabledByDefault=true)
public class DisassembleAtPcDebuggerBot
implements DebuggerBot {
    private DebuggerWorkflowServicePlugin plugin;
    private final MultiToolTraceListenerManager<ForDisassemblyTraceListener> listeners = new MultiToolTraceListenerManager<ForDisassemblyTraceListener>(x$0 -> new ForDisassemblyTraceListener((Trace)x$0));

    @Override
    public boolean isEnabled() {
        return this.plugin != null;
    }

    @Override
    public void enable(DebuggerWorkflowServicePlugin wp) {
        this.plugin = wp;
        this.listeners.enable(wp);
    }

    @Override
    public void disable() {
        this.plugin = null;
        this.listeners.disable();
    }

    @Override
    public void traceOpened(PluginTool tool, Trace trace) {
        this.listeners.traceOpened(tool, trace);
    }

    @Override
    public void traceClosed(PluginTool tool, Trace trace) {
        this.listeners.traceClosed(tool, trace);
    }

    protected class ForDisassemblyTraceListener
    extends AbstractMultiToolTraceListener {
        private final TraceStackManager stackManager;
        private final TraceMemoryManager memoryManager;
        private final TraceCodeManager codeManager;
        private final TraceTimeViewport viewport;
        private final Register pc;
        private final AddressRange pcRange;
        private final Set<DisassemblyInject> injects;
        private final ChangeListener injectsChangeListener;
        private final Deque<Runnable> runQueue;
        private final AsyncDebouncer<Void> runDebouncer;

        public ForDisassemblyTraceListener(Trace trace) {
            super(trace);
            this.injects = new LinkedHashSet<DisassemblyInject>();
            this.injectsChangeListener = e -> this.updateInjects();
            this.runQueue = new LinkedList<Runnable>();
            this.runDebouncer = new AsyncDebouncer(AsyncTimer.DEFAULT_TIMER, 100L);
            this.stackManager = trace.getStackManager();
            this.memoryManager = trace.getMemoryManager();
            this.codeManager = trace.getCodeManager();
            this.viewport = trace.getProgramView().getViewport();
            this.pc = trace.getBaseLanguage().getProgramCounter();
            this.pcRange = TraceRegisterUtils.rangeForRegister((Register)this.pc);
            ClassSearcher.addChangeListener((ChangeListener)this.injectsChangeListener);
            this.updateInjects();
            this.runDebouncer.addListener(this::processQueue);
            this.listenFor((TraceChangeType)Trace.TraceMemoryBytesChangeType.CHANGED, this::valuesChanged);
            this.listenFor((TraceChangeType)Trace.TraceStackChangeType.CHANGED, this::stackChanged);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateInjects() {
            Set<DisassemblyInject> set = this.injects;
            synchronized (set) {
                this.injects.clear();
                ClassSearcher.getInstances(DisassemblyInject.class).stream().filter(i -> i.isApplicable(this.trace)).sorted(Comparator.comparing(i -> i.getPriority())).forEach(this.injects::add);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void queueRunnable(Runnable r) {
            Deque<Runnable> deque = this.runQueue;
            synchronized (deque) {
                this.runQueue.add(r);
            }
            this.runDebouncer.contact(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processQueue(Void __) {
            try {
                List<Runnable> copy;
                Deque<Runnable> deque = this.runQueue;
                synchronized (deque) {
                    copy = List.copyOf(this.runQueue);
                    this.runQueue.clear();
                }
                for (Runnable r : copy) {
                    r.run();
                }
            }
            catch (Throwable e) {
                Msg.error((Object)((Object)this), (Object)"Error processing queue", (Throwable)e);
            }
        }

        private void valuesChanged(TraceAddressSpace space, TraceAddressSnapRange range, byte[] oldValue, byte[] newValue) {
            if (space.getAddressSpace().isRegisterSpace()) {
                this.registersChanged(space, range);
            } else {
                this.memoryChanged(range);
            }
        }

        private void stackChanged(TraceStack stack) {
            this.queueRunnable(() -> this.disassembleStackPcVals(stack, stack.getSnap(), null));
        }

        private long findNonScratchSnap(long snap) {
            if (snap >= 0L) {
                return snap;
            }
            TraceViewportSpanIterator spit = new TraceViewportSpanIterator(this.trace, snap);
            while (spit.hasNext()) {
                Range span = (Range)spit.next();
                if ((Long)span.upperEndpoint() < 0L) continue;
                return (Long)span.upperEndpoint();
            }
            return snap;
        }

        private void memoryChanged(TraceAddressSnapRange range) {
            if (!this.viewport.containsAnyUpper(range.getLifespan())) {
                return;
            }
            long pcSnap = this.trace.getProgramView().getSnap();
            long memSnap = range.getY1();
            this.queueRunnable(() -> {
                for (TraceThread thread : this.trace.getThreadManager().getLiveThreads(this.findNonScratchSnap(pcSnap))) {
                    TraceStack stack = this.stackManager.getLatestStack(thread, pcSnap);
                    if (stack != null) {
                        this.disassembleStackPcVals(stack, memSnap, range.getRange());
                        continue;
                    }
                    this.disassembleRegPcVal(thread, 0, pcSnap, memSnap);
                }
            });
        }

        private void registersChanged(TraceAddressSpace space, TraceAddressSnapRange range) {
            this.queueRunnable(() -> {
                long snap;
                if (space.getFrameLevel() != 0) {
                    return;
                }
                if (!range.getRange().intersects(this.pcRange)) {
                    return;
                }
                TraceThread thread = space.getThread();
                if (this.stackManager.getLatestStack(thread, snap = range.getY1().longValue()) != null) {
                    return;
                }
                this.disassembleRegPcVal(thread, space.getFrameLevel(), snap, snap);
            });
        }

        protected void disassembleStackPcVals(TraceStack stack, long memSnap, AddressRange range) {
            TraceStackFrame frame = stack.getFrame(0, false);
            if (frame == null) {
                return;
            }
            Address pcVal = frame.getProgramCounter();
            if (pcVal == null) {
                return;
            }
            if (range == null || range.contains(pcVal)) {
                this.disassemble(pcVal, stack.getThread(), memSnap);
            }
        }

        protected void disassembleRegPcVal(TraceThread thread, int frameLevel, long pcSnap, long memSnap) {
            Address pcVal;
            TraceData pcUnit = null;
            try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)this.trace, (String)"Disassemble: PC is code pointer", (boolean)true);){
                TraceCodeRegisterSpace regCode = this.codeManager.getCodeRegisterSpace(thread, frameLevel, true);
                try {
                    pcUnit = regCode.definedData().create(Range.atLeast((Comparable)Long.valueOf(pcSnap)), this.pc, (DataType)PointerDataType.dataType);
                }
                catch (CodeUnitInsertionException e) {
                    pcUnit = (TraceData)regCode.definedData().getForRegister(pcSnap, this.pc);
                }
            }
            if (pcUnit != null && (pcVal = (Address)TraceRegisterUtils.getValueHackPointer((TraceData)pcUnit)) != null) {
                this.disassemble(pcVal, thread, memSnap);
            }
        }

        protected Long isKnownRWOrEverKnownRO(Address start, long snap) {
            Map.Entry kent = this.memoryManager.getViewState(snap, start);
            if (kent != null && kent.getValue() == TraceMemoryState.KNOWN) {
                return (Long)kent.getKey();
            }
            Map.Entry mrent = this.memoryManager.getViewMostRecentStateEntry(snap, start);
            if (mrent == null || mrent.getValue() != TraceMemoryState.KNOWN) {
                return null;
            }
            TraceMemoryRegion region = this.memoryManager.getRegionContaining(((TraceAddressSnapRange)mrent.getKey()).getY1().longValue(), start);
            if (region == null || region.isWrite()) {
                return null;
            }
            return ((TraceAddressSnapRange)mrent.getKey()).getY1();
        }

        protected void disassemble(final Address start, final TraceThread thread, long snap) {
            Long knownSnap = this.isKnownRWOrEverKnownRO(start, snap);
            if (knownSnap == null) {
                return;
            }
            final long ks = knownSnap;
            if (this.codeManager.definedUnits().containsAddress(ks, start)) {
                return;
            }
            AddressSetView readOnly = this.memoryManager.getRegionsAddressSetWith(ks, r -> !r.isWrite());
            AddressSetView everKnown = this.memoryManager.getAddressesWithState(Range.atMost((Comparable)Long.valueOf(ks)), s -> s == TraceMemoryState.KNOWN);
            IntersectionAddressSetView roEverKnown = new IntersectionAddressSetView(readOnly, everKnown);
            AddressSetView known = this.memoryManager.getAddressesWithState(ks, s -> s == TraceMemoryState.KNOWN);
            AddressSet disassemblable = new AddressSet((AddressSetView)new UnionAddressSetView(new AddressSetView[]{known, roEverKnown}));
            final TraceProgramView view = this.trace.getFixedProgramView(ks);
            DisassembleCommand dis = new DisassembleCommand(start, (AddressSetView)disassemblable, true, (AddressSetView)disassemblable){
                final /* synthetic */ AddressSetView val$disassemblable;
                {
                    this.val$disassemblable = addressSetView;
                    super(arg0, arg1, arg2);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
                    Set<DisassemblyInject> set = ForDisassemblyTraceListener.this.injects;
                    synchronized (set) {
                        if (ForDisassemblyTraceListener.this.codeManager.definedUnits().containsAddress(ks, start)) {
                            return true;
                        }
                        for (DisassemblyInject i : ForDisassemblyTraceListener.this.injects) {
                            i.pre(DisassembleAtPcDebuggerBot.this.plugin.getTool(), this, view, thread, (AddressSetView)new AddressSet(start, start), this.val$disassemblable);
                        }
                        boolean result = super.applyTo(obj, monitor);
                        if (!result) {
                            return false;
                        }
                        for (DisassemblyInject i : ForDisassemblyTraceListener.this.injects) {
                            i.post(DisassembleAtPcDebuggerBot.this.plugin.getTool(), view, (AddressSetView)this.getDisassembledAddressSet());
                        }
                        return result;
                    }
                }
            };
            DisassembleAtPcDebuggerBot.this.plugin.getTool().executeBackgroundCommand((BackgroundCommand)dis, (UndoableDomainObject)view);
        }
    }
}

