/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsProvider;
import ghidra.app.plugin.core.debug.gui.objects.ObjectContainer;
import ghidra.async.AsyncFence;
import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.async.seq.AsyncSequenceHandlerForRunner;
import ghidra.dbg.target.TargetObject;
import ghidra.framework.plugintool.PluginTool;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;

public abstract class DisplayAsAction
extends DockingAction {
    protected PluginTool tool;
    protected DebuggerObjectsProvider provider;
    protected boolean isTree = false;

    public DisplayAsAction(String name, PluginTool tool, String owner, DebuggerObjectsProvider provider) {
        super(name, owner);
        this.tool = tool;
        this.provider = provider;
    }

    public boolean isEnabledForContext(ActionContext context) {
        Object obj = context.getContextObject();
        ObjectContainer sel = this.provider.getSelectedContainer(obj);
        return sel != null;
    }

    public void actionPerformed(ActionContext context) {
        Object contextObject = context.getContextObject();
        ObjectContainer container = this.provider.getSelectedContainer(contextObject);
        if (container != null) {
            this.doAction(container);
        }
    }

    protected abstract void doAction(ObjectContainer var1);

    protected CompletableFuture<Void> getOffspring(ObjectContainer container) {
        AtomicReference elements = new AtomicReference();
        AtomicReference attributes = new AtomicReference();
        return AsyncUtils.sequence((TypeSpec)TypeSpec.VOID).then(seq -> {
            AsyncFence fence = new AsyncFence();
            TargetObject to = container.getTargetObject();
            fence.include((CompletableFuture)to.fetchElements().thenAccept(elements::set));
            fence.include((CompletableFuture)to.fetchAttributes().thenAccept(attributes::set));
            fence.ready().handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForRunner)seq).next(arg_0, arg_1));
        }).then(seq -> {
            container.rebuildContainers((Map)elements.get(), (Map)attributes.get());
            this.finishGetOffspring(container);
            seq.exit();
        }).finish();
    }

    protected void finishGetOffspring(ObjectContainer container) {
        SwingUtilities.invokeLater(() -> {
            try {
                DebuggerObjectsProvider p = new DebuggerObjectsProvider(this.provider.getPlugin(), this.provider.getModel(), container, this.isTree);
                container.propagateProvider(p);
                p.update(container);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }
}

