/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.threaded;

import docking.widgets.table.AddRemoveListItem;
import docking.widgets.table.TableSortingContext;
import docking.widgets.table.threaded.TableAddRemoveStrategy;
import docking.widgets.table.threaded.TableData;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefaultAddRemoveStrategy<T>
implements TableAddRemoveStrategy<T> {
    @Override
    public void process(List<AddRemoveListItem<T>> addRemoveList, TableData<T> tableData, TaskMonitor monitor) throws CancelledException {
        int n = addRemoveList.size();
        monitor.setMessage("Adding/Removing " + n + " items...");
        monitor.initialize((long)n);
        HashSet<T> failedToRemove = new HashSet<T>();
        for (int i = 0; i < n; ++i) {
            AddRemoveListItem<T> item = addRemoveList.get(i);
            T value = item.getValue();
            if (item.isChange()) {
                tableData.remove(value);
                tableData.insert(value);
            } else if (item.isRemove()) {
                if (!tableData.remove(value)) {
                    failedToRemove.add(value);
                }
            } else if (item.isAdd()) {
                tableData.insert(value);
            }
            monitor.checkCanceled();
            monitor.setProgress((long)i);
        }
        if (!failedToRemove.isEmpty()) {
            int size = failedToRemove.size();
            Object message = size == 1 ? "1 deleted item..." : size + " deleted items...";
            monitor.setMessage("Removing " + (String)message);
            tableData.process((data, sortContext) -> this.expungeLostItems((Set<T>)failedToRemove, (List<T>)data, (TableSortingContext<T>)sortContext));
        }
        monitor.setMessage("Done adding/removing");
    }

    private List<T> expungeLostItems(Set<T> toRemove, List<T> data, TableSortingContext<T> sortContext) {
        ArrayList<T> newList = new ArrayList<T>(data.size() - toRemove.size());
        for (int i = 0; i < data.size(); ++i) {
            T rowObject = data.get(i);
            if (toRemove.contains(rowObject)) continue;
            newList.add(rowObject);
        }
        return newList;
    }
}

