/*
 * Decompiled with CFR 0.152.
 */
package docking.actions;

import docking.ActionContext;
import docking.DockingWindowManager;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.KeyBindingType;
import docking.actions.KeyBindingUtils;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.KeyStroke;
import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.bag.HashBag;
import org.apache.commons.lang3.StringUtils;

public class SharedStubKeyBindingAction
extends DockingAction
implements OptionsChangeListener {
    static final String SHARED_OWNER = "Shared";
    private WeakHashMap<DockingActionIf, KeyStroke> clientActions = new WeakHashMap();
    private ToolOptions keyBindingOptions;
    private Bag<String> actionOwners = new HashBag();

    SharedStubKeyBindingAction(String name, KeyStroke defaultKs, ToolOptions options) {
        super(name, SHARED_OWNER, KeyBindingType.INDIVIDUAL);
        this.keyBindingOptions = options;
        DockingWindowManager.getHelpService().excludeFromHelp(this);
        this.setUnvalidatedKeyBindingData(new KeyBindingData(defaultKs));
        options.addOptionsChangeListener((OptionsChangeListener)this);
    }

    void addActionOwner(String owner) {
        if ("DockingWindows".equals(owner)) {
            return;
        }
        this.actionOwners.add((Object)owner);
    }

    void removeClientAction(DockingActionIf action) {
        this.clientActions.remove(action);
        this.actionOwners.remove((Object)action.getOwner());
    }

    void addClientAction(DockingActionIf action) {
        KeyStroke defaultKs = this.validateActionsHaveTheSameDefaultKeyStroke(action);
        this.clientActions.put(action, defaultKs);
        this.updateActionKeyStrokeFromOptions(action, defaultKs);
    }

    @Override
    public String getOwnerDescription() {
        LinkedList<String> owners = new LinkedList<String>(this.actionOwners.uniqueSet());
        if (owners.size() == 1) {
            return (String)owners.get(0);
        }
        boolean hasTool = owners.remove(SHARED_OWNER);
        Collections.sort(owners);
        if (hasTool) {
            owners.add(0, SHARED_OWNER);
        }
        return StringUtils.join(owners, (String)", ");
    }

    @Override
    public String getDescription() {
        Set<DockingActionIf> actions = this.clientActions.keySet();
        for (DockingActionIf action : actions) {
            String description = action.getDescription();
            if (StringUtils.isBlank((CharSequence)description)) continue;
            return description;
        }
        return super.getDescription();
    }

    private KeyStroke validateActionsHaveTheSameDefaultKeyStroke(DockingActionIf newAction) {
        KeyBindingData defaultBinding = newAction.getDefaultKeyBindingData();
        KeyStroke newDefaultKs = this.getKeyStroke(defaultBinding);
        Set<Map.Entry<DockingActionIf, KeyStroke>> entries = this.clientActions.entrySet();
        for (Map.Entry<DockingActionIf, KeyStroke> entry : entries) {
            DockingActionIf existingAction = entry.getKey();
            KeyStroke existingDefaultKs = entry.getValue();
            if (Objects.equals(existingDefaultKs, newDefaultKs)) continue;
            KeyBindingUtils.logDifferentKeyBindingsWarnigMessage(newAction, existingAction, existingDefaultKs);
            newAction.setKeyBindingData(new KeyBindingData(existingDefaultKs));
            return existingDefaultKs;
        }
        return newDefaultKs;
    }

    private void updateActionKeyStrokeFromOptions(DockingActionIf action, KeyStroke defaultKs) {
        KeyStroke stubKs = defaultKs;
        KeyStroke optionsKs = this.getKeyStrokeFromOptions(defaultKs);
        if (!Objects.equals(defaultKs, optionsKs)) {
            action.setUnvalidatedKeyBindingData(new KeyBindingData(optionsKs));
            stubKs = optionsKs;
        }
        this.setUnvalidatedKeyBindingData(new KeyBindingData(stubKs));
    }

    private KeyStroke getKeyStrokeFromOptions(KeyStroke validatedKeyStroke) {
        KeyStroke ks = this.keyBindingOptions.getKeyStroke(this.getFullName(), validatedKeyStroke);
        return ks;
    }

    private KeyStroke getKeyStroke(KeyBindingData data) {
        if (data == null) {
            return null;
        }
        return data.getKeyBinding();
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        if (!optionName.equals(this.getFullName())) {
            return;
        }
        KeyStroke newKs = (KeyStroke)newValue;
        for (DockingActionIf action : this.clientActions.keySet()) {
            action.setUnvalidatedKeyBindingData(new KeyBindingData(newKs));
        }
    }

    @Override
    public void actionPerformed(ActionContext context) {
    }

    @Override
    public boolean isAddToPopup(ActionContext context) {
        return false;
    }

    @Override
    public boolean isEnabledForContext(ActionContext context) {
        return false;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.clientActions.clear();
        this.keyBindingOptions.removeOptionsChangeListener((OptionsChangeListener)this);
    }
}

