/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.impl;

import ghidra.feature.vt.api.db.VTAssociationDB;
import ghidra.feature.vt.api.main.VTAssociationType;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.markuptype.VTMarkupType;
import ghidra.feature.vt.api.markuptype.VTMarkupTypeFactory;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class MarkupItemFactory {
    private MarkupItemFactory() {
    }

    public static Collection<VTMarkupItem> generateMarkupItems(TaskMonitor monitor, VTAssociationDB association) throws CancelledException {
        ArrayList<VTMarkupItem> list = new ArrayList<VTMarkupItem>();
        List<VTMarkupType> values = VTMarkupTypeFactory.getMarkupTypes();
        monitor.setMessage("Searching unapplied for markup items");
        monitor.initialize((long)values.size());
        VTAssociationType associationType = association.getType();
        for (VTMarkupType type : values) {
            monitor.checkCanceled();
            if (type.supportsAssociationType(associationType)) {
                list.addAll(MarkupItemFactory.createMarkupItems(type, association));
            }
            monitor.incrementProgress(1L);
        }
        monitor.setProgress((long)values.size());
        return list;
    }

    private static List<VTMarkupItem> createMarkupItems(VTMarkupType type, VTAssociationDB association) {
        try {
            return type.createMarkupItems(association);
        }
        catch (Exception e) {
            Msg.debug(MarkupItemFactory.class, (Object)"Unexpected exception creating markup items.  ", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

