/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.MappedEntry;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.InvalidInputException;

public class HighFunctionSymbol
extends HighSymbol {
    public HighFunctionSymbol(Address addr, int size, HighFunction function) {
        super(function.getID(), "", DataType.DEFAULT, function);
        VariableStorage store;
        try {
            store = new VariableStorage(this.getProgram(), addr, size);
        }
        catch (InvalidInputException e) {
            store = VariableStorage.UNASSIGNED_STORAGE;
        }
        MappedEntry entry = new MappedEntry(this, store, null);
        this.addMapEntry(entry);
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    public Namespace getNamespace() {
        Function func = this.function.getFunction();
        Namespace namespc = func.getParentNamespace();
        while (func.isThunk() && namespc.getID() == 0L) {
            func = func.getThunkedFunction(false);
            namespc = func.getParentNamespace();
        }
        return namespc;
    }

    @Override
    public void saveXML(StringBuilder buf) {
        MappedEntry entry = (MappedEntry)this.getFirstWholeMap();
        String funcString = this.function.buildFunctionXML(this.getId(), this.getNamespace(), entry.getStorage().getMinAddress(), entry.getSize());
        buf.append(funcString);
    }
}

