/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.SignedByteDataType;
import ghidra.program.model.lang.DecompilerLanguage;

public class ByteDataType
extends AbstractIntegerDataType {
    private static final long serialVersionUID = 1L;
    public static final ByteDataType dataType = new ByteDataType();

    public ByteDataType() {
        this(null);
    }

    public ByteDataType(DataTypeManager dtm) {
        super("byte", false, dtm);
    }

    @Override
    public String getDescription() {
        return "Unsigned Byte (db)";
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public String getAssemblyMnemonic() {
        return "db";
    }

    @Override
    public String getDecompilerDisplayName(DecompilerLanguage language) {
        if (language == DecompilerLanguage.JAVA_LANGUAGE) {
            return "ubyte";
        }
        return this.name;
    }

    @Override
    public SignedByteDataType getOppositeSignednessDataType() {
        return SignedByteDataType.dataType.clone(this.getDataTypeManager());
    }

    @Override
    public ByteDataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new ByteDataType(dtm);
    }
}

