/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.jparted.lib.fs.hfscommon;

import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogFileRecord;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogFolder;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogFolderRecord;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogLeafRecord;
import org.catacombae.jparted.lib.fs.FSAttributes;
import org.catacombae.jparted.lib.fs.FSEntry;
import org.catacombae.jparted.lib.fs.FSFolder;
import org.catacombae.jparted.lib.fs.hfscommon.HFSCommonFSAttributes;
import org.catacombae.jparted.lib.fs.hfscommon.HFSCommonFileSystemHandler;

public class HFSCommonFSFolder
extends FSFolder {
    private final HFSCommonFileSystemHandler fsHandler;
    private final CommonHFSCatalogLeafRecord keyRecord;
    private final CommonHFSCatalogFolderRecord folderRecord;
    private final CommonHFSCatalogFolder catalogFolder;
    private final HFSCommonFSAttributes attributes;

    public HFSCommonFSFolder(HFSCommonFileSystemHandler iParent, CommonHFSCatalogFolderRecord iFolderRecord) {
        this(iParent, null, iFolderRecord);
    }

    HFSCommonFSFolder(HFSCommonFileSystemHandler iParent, CommonHFSCatalogFileRecord iHardLinkFileRecord, CommonHFSCatalogFolderRecord iFolderRecord) {
        super(iParent);
        if (iParent == null) {
            throw new IllegalArgumentException("iParent must not be null!");
        }
        if (iFolderRecord == null) {
            throw new IllegalArgumentException("iFolderRecord must not be null!");
        }
        this.fsHandler = iParent;
        this.keyRecord = iHardLinkFileRecord != null ? iHardLinkFileRecord : iFolderRecord;
        this.folderRecord = iFolderRecord;
        this.catalogFolder = this.folderRecord.getData();
        this.attributes = new HFSCommonFSAttributes(this, this.catalogFolder);
    }

    public String[] list() {
        return this.fsHandler.listNames(this.folderRecord);
    }

    public FSEntry[] listEntries() {
        return this.fsHandler.listFSEntries(this.folderRecord);
    }

    public FSEntry getChild(String name) {
        return this.fsHandler.getEntry(this.folderRecord, name);
    }

    public long getValence() {
        return this.catalogFolder.getValence();
    }

    public FSAttributes getAttributes() {
        return this.attributes;
    }

    public String getName() {
        return this.fsHandler.getProperNodeName(this.keyRecord);
    }

    public CommonHFSCatalogFolder getInternalCatalogFolder() {
        return this.catalogFolder;
    }

    CommonHFSCatalogFolderRecord getInternalCatalogFolderRecord() {
        return this.folderRecord;
    }
}

