/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem;

import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public interface GIconProvider {
    public Icon getIcon(GFile var1, TaskMonitor var2) throws IOException, CancelledException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Icon getIconForFile(GFile file, TaskMonitor monitor) throws CancelledException {
        try {
            GFileSystem fs = file.getFilesystem();
            if (fs instanceof GIconProvider) {
                return ((GIconProvider)((Object)fs)).getIcon(file, monitor);
            }
            try (InputStream is = file.getFilesystem().getInputStream(file, monitor);){
                BufferedImage image = ImageIO.read(is);
                if (image == null) {
                    Icon icon = null;
                    return icon;
                }
                ImageIcon imageIcon = new ImageIcon(image);
                return imageIcon;
            }
            catch (Exception e) {
                Msg.error(GIconProvider.class, (Object)("Exception while reading image " + file.getName()), (Throwable)e);
                return null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

