/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.coff;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.coff.BigEndianUnitSizeByteSwapperInputStream;
import ghidra.app.util.bin.format.coff.CoffFileHeader;
import ghidra.app.util.bin.format.coff.CoffLineNumber;
import ghidra.app.util.bin.format.coff.CoffRelocation;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.lang.Language;
import ghidra.util.BigEndianDataConverter;
import ghidra.util.LittleEndianDataConverter;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class CoffSectionHeader
implements StructConverter {
    protected String s_name;
    protected int s_paddr;
    protected int s_vaddr;
    protected int s_size;
    protected int s_scnptr;
    protected int s_relptr;
    protected int s_lnnoptr;
    protected int s_nreloc;
    protected int s_nlnno;
    protected int s_flags;
    protected short s_reserved;
    protected short s_page;
    protected CoffFileHeader _header;
    protected List<CoffRelocation> _relocations = new ArrayList<CoffRelocation>();
    protected List<CoffLineNumber> _lineNumbers = new ArrayList<CoffLineNumber>();

    protected CoffSectionHeader() {
    }

    CoffSectionHeader(BinaryReader reader, CoffFileHeader header) throws IOException {
        this._header = header;
        this.readName(reader);
        this.s_paddr = reader.readNextInt();
        this.s_vaddr = reader.readNextInt();
        this.s_size = reader.readNextInt();
        this.s_scnptr = reader.readNextInt();
        this.s_relptr = reader.readNextInt();
        this.s_lnnoptr = reader.readNextInt();
        this.s_nreloc = reader.readNextUnsignedShort();
        this.s_nlnno = reader.readNextUnsignedShort();
        this.s_flags = reader.readNextInt();
        this.s_reserved = 0;
        this.s_page = 0;
    }

    protected void readName(BinaryReader reader) throws IOException {
        byte[] nameBytes = reader.readNextByteArray(8);
        if (nameBytes[0] == 0 && nameBytes[1] == 0 && nameBytes[2] == 0 && nameBytes[3] == 0) {
            LittleEndianDataConverter dc = reader.isLittleEndian() ? LittleEndianDataConverter.INSTANCE : BigEndianDataConverter.INSTANCE;
            int nameIndex = dc.getInt(nameBytes, 4);
            int stringTableIndex = this._header.getSymbolTablePointer() + this._header.getSymbolTableEntries() * 18;
            this.s_name = reader.readAsciiString(stringTableIndex + nameIndex);
        } else {
            this.s_name = new String(nameBytes).trim();
        }
    }

    public String getName() {
        return this.s_name;
    }

    public int getPhysicalAddress() {
        return this.s_paddr;
    }

    public void move(int offset) {
        this.s_paddr += offset;
    }

    public Address getPhysicalAddress(Language language) {
        return CoffSectionHeader.getAddress(language, (long)this.s_paddr, this);
    }

    public int getVirtualAddress() {
        return this.s_vaddr;
    }

    public boolean isExplicitlyByteAligned() {
        return (this.s_reserved & 8) != 0;
    }

    public int getSize(Language language) {
        if (this.isExplicitlyByteAligned()) {
            return this.s_size;
        }
        Address physicalAddr = this.getPhysicalAddress(language);
        return this.s_size * physicalAddr.getAddressSpace().getAddressableUnitSize();
    }

    public int getPointerToRawData() {
        return this.s_scnptr;
    }

    public int getPointerToRelocations() {
        return this.s_relptr;
    }

    public int getPointerToLineNumbers() {
        return this.s_lnnoptr;
    }

    public int getRelocationCount() {
        return this.s_nreloc;
    }

    public int getLineNumberCount() {
        return this.s_nlnno;
    }

    public int getFlags() {
        return this.s_flags;
    }

    public short getReserved() {
        return this.s_reserved;
    }

    public short getPage() {
        return this.s_page;
    }

    public InputStream getRawDataStream(ByteProvider provider, Language language) throws IOException {
        int addressableUnitSize = language.getAddressFactory().getDefaultAddressSpace().getAddressableUnitSize();
        if (addressableUnitSize > 1 && language.isBigEndian()) {
            return new BigEndianUnitSizeByteSwapperInputStream(provider.getInputStream(this.s_scnptr), addressableUnitSize);
        }
        return provider.getInputStream(this.s_scnptr);
    }

    public boolean isProcessedBytes(Language language) {
        int addressableUnitSize = language.getAddressFactory().getDefaultAddressSpace().getAddressableUnitSize();
        return addressableUnitSize > 1 && language.isBigEndian();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parse(BinaryReader reader, CoffFileHeader header, TaskMonitor monitor) throws IOException {
        long origIndex = reader.getPointerIndex();
        try {
            this.parseRelocations(reader, header, monitor);
            this.parseLineNumbers(reader, monitor);
        }
        finally {
            reader.setPointerIndex(origIndex);
        }
    }

    private void parseLineNumbers(BinaryReader reader, TaskMonitor monitor) throws IOException {
        reader.setPointerIndex(this.s_lnnoptr);
        for (int i = 0; i < this.s_nlnno && !monitor.isCancelled(); ++i) {
            this._lineNumbers.add(new CoffLineNumber(reader));
        }
    }

    private void parseRelocations(BinaryReader reader, CoffFileHeader header, TaskMonitor monitor) throws IOException {
        reader.setPointerIndex(this.s_relptr);
        for (int i = 0; i < this.s_nreloc && !monitor.isCancelled(); ++i) {
            this._relocations.add(new CoffRelocation(reader, header));
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(StructConverterUtil.parseName(this.getClass()), 0);
        struct.add((DataType)new ArrayDataType(ASCII, 8, ASCII.getLength()), "s_name", null);
        struct.add(DWORD, "s_paddr", null);
        struct.add(DWORD, "s_vaddr", null);
        struct.add(DWORD, "s_size", null);
        struct.add(DWORD, "s_scnptr", null);
        struct.add(DWORD, "s_relptr", null);
        struct.add(DWORD, "s_lnnoptr", null);
        struct.add(WORD, "s_nreloc", null);
        struct.add(WORD, "s_nlnno", null);
        struct.add(DWORD, "s_flags", null);
        return struct;
    }

    public boolean isUninitializedData() {
        return ((long)this.s_flags & 0x80L) != 0L || this.s_scnptr == 0;
    }

    public boolean isInitializedData() {
        return ((long)this.s_flags & 0x40L) != 0L && ((long)this.s_flags & 0x20L) == 0L;
    }

    public boolean isData() {
        return this.isInitializedData() || this.isUninitializedData();
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isGroup() {
        return ((long)this.s_flags & 4L) != 0L;
    }

    public boolean isWritable() {
        return ((long)this.s_flags & 0x20L) == 0L;
    }

    public boolean isExecutable() {
        return ((long)this.s_flags & 0x20L) != 0L;
    }

    public boolean isAllocated() {
        return ((long)this.s_flags & 0x10L) == 0L && ((long)this.s_flags & 8L) == 0L && ((long)this.s_flags & 1L) == 0L;
    }

    public List<CoffRelocation> getRelocations() {
        return new ArrayList<CoffRelocation>(this._relocations);
    }

    public List<CoffLineNumber> getLineNumbers() {
        return new ArrayList<CoffLineNumber>(this._lineNumbers);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getName());
        buffer.append(' ');
        buffer.append("PhysAddr:0x" + Integer.toHexString(this.s_paddr));
        buffer.append(' ');
        buffer.append("Size:0x" + Integer.toHexString(this.s_size));
        buffer.append(' ');
        buffer.append("Flags:0x" + Integer.toHexString(this.s_flags));
        buffer.append(' ');
        return buffer.toString();
    }

    private static int getOffsetUnitSize(Language language, CoffSectionHeader section) {
        AddressSpace codeSpace = language.getDefaultSpace();
        if (section == null || !section.isExplicitlyByteAligned()) {
            return codeSpace.getAddressableUnitSize();
        }
        return 1;
    }

    public static Address getAddress(Language language, long offset, CoffSectionHeader section) {
        AddressSpace space;
        boolean isData = section == null || section.isData();
        AddressSpace addressSpace = space = isData ? language.getDefaultDataSpace() : language.getDefaultSpace();
        if (offset > space.getMaxAddress().getAddressableWordOffset()) {
            space = !isData ? language.getDefaultDataSpace() : language.getDefaultSpace();
        }
        return space.getAddress(offset * (long)CoffSectionHeader.getOffsetUnitSize(language, section));
    }

    public static Address getAddress(Language language, long offset, AddressSpace space) {
        return space.getAddress(offset * (long)CoffSectionHeader.getOffsetUnitSize(language, null));
    }
}

