/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.equate;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateReference;
import ghidra.program.model.symbol.EquateTable;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

class RenameEquatesCmd
implements Command {
    private String newEquateName;
    private String oldEquateName;
    private String msg;

    RenameEquatesCmd(String oldEquateName, String newEquateName) {
        this.oldEquateName = oldEquateName;
        this.newEquateName = newEquateName;
    }

    public String getName() {
        return "Rename Equates";
    }

    public boolean applyTo(DomainObject obj) {
        EquateTable etable = ((Program)obj).getEquateTable();
        Equate fromEquate = etable.getEquate(this.oldEquateName);
        if (fromEquate == null) {
            this.msg = "Equate not found: " + this.oldEquateName;
            return false;
        }
        Equate toEquate = etable.getEquate(this.newEquateName);
        if (toEquate == null) {
            try {
                toEquate = etable.createEquate(this.newEquateName, fromEquate.getValue());
            }
            catch (DuplicateNameException e) {
                throw new AssertException();
            }
            catch (InvalidInputException e) {
                this.msg = "Invalid equate name: " + this.newEquateName;
                return false;
            }
        }
        EquateReference[] refList = fromEquate.getReferences();
        etable.removeEquate(this.oldEquateName);
        for (EquateReference element : refList) {
            toEquate.addReference(element.getAddress(), (int)element.getOpIndex());
        }
        return true;
    }

    public String getStatusMsg() {
        return this.msg;
    }
}

