/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hemf.record;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hemf.record.HemfRecord;
import org.apache.poi.hemf.record.HemfRecordType;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndianInputStream;

@Internal
public class UnimplementedHemfRecord
implements HemfRecord {
    private long recordId;

    @Override
    public HemfRecordType getRecordType() {
        return HemfRecordType.getById(this.recordId);
    }

    @Override
    public long init(LittleEndianInputStream leis, long recordId, long recordSize) throws IOException {
        this.recordId = recordId;
        long skipped = IOUtils.skipFully((InputStream)leis, (long)recordSize);
        if (skipped < recordSize) {
            throw new IOException("End of stream reached before record read");
        }
        return skipped;
    }
}

