/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.integration;

import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.snpeff.SnpEff;
import org.snpeff.snpEffect.commandLine.SnpEffCmdEff;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VcfEffect;
import org.snpeff.vcf.VcfEntry;

public class TestCasesIntegrationFilterTranscripts {
    boolean verbose = false;

    @Test
    public void test_01() {
        Gpr.debug("Test");
        String[] args = new String[]{"-noStats", "-i", "vcf", "-o", "vcf", "-classic", "-onlyTr", "tests/filterTranscripts_01.txt", "testHg3765Chr22", "tests/test_filter_transcripts_001.vcf"};
        SnpEff cmd = new SnpEff(args);
        SnpEffCmdEff cmdEff = (SnpEffCmdEff)cmd.cmd();
        cmdEff.setVerbose(this.verbose);
        cmdEff.setSupressOutput(!this.verbose);
        List<VcfEntry> vcfEntries = cmdEff.run(true);
        Assert.assertTrue("Errors while executing SnpEff", cmdEff.getTotalErrs() <= 0);
        for (VcfEntry ve : vcfEntries) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (VcfEffect veff : ve.getVcfEffects()) {
                if (this.verbose) {
                    System.out.println("\ttrId:" + veff.getTranscriptId() + "\t" + veff);
                }
                Assert.assertEquals("ENST00000400573", veff.getTranscriptId());
            }
        }
    }

    @Test
    public void test_02() {
        Gpr.debug("Test");
        String[] args = new String[]{"-noStats", "-i", "vcf", "-o", "vcf", "-classic", "-onlyTr", "tests/filterTranscripts_02.txt", "testHg3765Chr22", "tests/test_filter_transcripts_001.vcf"};
        SnpEff cmd = new SnpEff(args);
        SnpEffCmdEff cmdEff = (SnpEffCmdEff)cmd.cmd();
        cmdEff.setVerbose(this.verbose);
        cmdEff.setSupressOutput(!this.verbose);
        List<VcfEntry> vcfEntries = cmdEff.run(true);
        Assert.assertTrue("Errors while executing SnpEff", cmdEff.getTotalErrs() <= 0);
        for (VcfEntry ve : vcfEntries) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (VcfEffect veff : ve.getVcfEffects()) {
                if (this.verbose) {
                    System.out.println("\ttrId:" + veff.getTranscriptId() + "\t" + veff);
                }
                if (veff.getTranscriptId().equals("ENST00000400573") || veff.getTranscriptId().equals("ENST00000262608")) continue;
                throw new RuntimeException("This transcript should not be here! " + veff);
            }
        }
    }
}

