/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.commandLine;

import org.snpeff.SnpEff;
import org.snpeff.nextProt.NextProtDb;
import org.snpeff.util.Timer;

public class SnpEffCmdBuildNextProt
extends SnpEff {
    String xmlDirName;
    String trIdFile;

    @Override
    public void parseArgs(String[] args) {
        this.args = args;
        if (args.length <= 0) {
            this.usage(null);
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (this.isOpt(arg)) {
                switch (arg.toLowerCase()) {
                    case "-trids": {
                        if (i + 1 < args.length) {
                            this.trIdFile = args[++i];
                            break;
                        }
                        this.usage("Option '-trids' without transcript id file");
                        break;
                    }
                    default: {
                        this.usage("Unknonwn option '" + arg + "'");
                        break;
                    }
                }
                continue;
            }
            if (this.genomeVer == null || this.genomeVer.isEmpty()) {
                this.genomeVer = args[i];
                continue;
            }
            if (this.xmlDirName != null && !this.xmlDirName.isEmpty()) continue;
            this.xmlDirName = args[i];
        }
        if (this.genomeVer == null || this.genomeVer.isEmpty()) {
            this.usage("Missing genome version");
        }
        if (this.xmlDirName == null || this.xmlDirName.isEmpty()) {
            this.usage("Missing nextProt XML dir");
        }
    }

    @Override
    public boolean run() {
        this.loadConfig();
        this.loadDb();
        NextProtDb nextProtDb = new NextProtDb(this.xmlDirName, this.config);
        nextProtDb.setVerbose(this.verbose);
        nextProtDb.setDebug(this.debug);
        nextProtDb.setTrIdFile(this.trIdFile);
        nextProtDb.parse();
        nextProtDb.saveDatabase();
        if (this.verbose) {
            Timer.showStdErr("Done!");
        }
        return true;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error        :\t" + message);
        }
        System.err.println("snpEff version " + VERSION);
        System.err.println("Usage: snpEff buildNextProt [options] genome_version nextProt_XML_dir");
        System.err.println("\t-trIds <file.txt>      : Transcript IDs map file. Format 'ENSEMBL_TR_ID \t REFSEQ_TR_ID'.");
        System.exit(-1);
    }
}

