/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.pdb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.snpeff.collections.AutoHashMap;
import org.snpeff.pdb.IdMapperEntry;
import org.snpeff.util.Gpr;
import org.snpeff.util.Timer;

public class IdMapper {
    boolean verbose;
    int count;
    AutoHashMap<String, ArrayList<IdMapperEntry>> byTrId;
    AutoHashMap<String, ArrayList<IdMapperEntry>> byPdbId;
    HashSet<IdMapperEntry> entries;

    public static String transcriptIdNoVersion(String trId) {
        int idx = trId.lastIndexOf(46);
        if (idx < 0) {
            return trId;
        }
        return trId.substring(0, idx);
    }

    public static Set<String> transcriptIds(List<IdMapperEntry> ids) {
        if (ids == null) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        for (IdMapperEntry ime : ids) {
            set.add(ime.trId);
        }
        return set;
    }

    public IdMapper() {
        ArrayList emptyList = new ArrayList();
        this.byTrId = new AutoHashMap(emptyList);
        this.byPdbId = new AutoHashMap(emptyList);
        this.entries = new HashSet();
    }

    public void add(IdMapperEntry ime) {
        if (ime.trId != null) {
            this.byTrId.getOrCreate(ime.trId).add(ime);
        }
        if (ime.pdbId != null) {
            this.byPdbId.getOrCreate(ime.pdbId).add(ime);
        }
        this.entries.add(ime);
    }

    public void addAll(Collection<IdMapperEntry> imes) {
        for (IdMapperEntry ime : imes) {
            this.add(ime);
        }
    }

    public List<IdMapperEntry> getByPdbId(String id) {
        return (List)this.byPdbId.get(id);
    }

    public List<IdMapperEntry> getByPdbId(String id, String chainId) {
        if (this.byPdbId.get(id) == null) {
            return null;
        }
        LinkedList<IdMapperEntry> list2 = new LinkedList<IdMapperEntry>();
        for (IdMapperEntry ime : (ArrayList)this.byPdbId.get(id)) {
            if (!chainId.equals(ime.pdbChainId)) continue;
            list2.add(ime);
        }
        return list2;
    }

    public List<IdMapperEntry> getByTrId(String id) {
        return (List)this.byTrId.get(id);
    }

    public Collection<IdMapperEntry> getEntries() {
        return this.entries;
    }

    public void load(String fileName) {
        String[] lines2;
        if (this.verbose) {
            Timer.showStdErr("Loading IDs from file: " + fileName);
        }
        this.count = 0;
        for (String line : lines2 = Gpr.readFile(fileName).split("\n")) {
            this.parseLine(line);
        }
        if (this.verbose) {
            Timer.showStdErr("Done. Total entries added: " + this.count);
        }
    }

    void parseLine(String line) {
        IdMapperEntry ime;
        String[] fields = line.split("\t");
        if (fields.length > 1 && !fields[1].isEmpty()) {
            ime = new IdMapperEntry(fields[0], fields[1]);
            this.add(ime);
            ++this.count;
        }
        if (fields.length > 2 && !fields[2].isEmpty()) {
            ime = new IdMapperEntry(fields[0], fields[2]);
            this.add(ime);
            ++this.count;
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IdMapperEntry im : this.entries) {
            sb.append(im + "\n");
        }
        return sb.toString();
    }
}

